/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import java.util.Optional;
import org.springframework.data.mongodb.core.Collation;
import org.springframework.util.Assert;

public class CollectionOptions {
    private Integer maxDocuments;
    private Integer size;
    private Boolean capped;
    private Optional<Collation> collation;

    public CollectionOptions(Integer size, Integer maxDocuments, Boolean capped) {
        this(size, maxDocuments, capped, Optional.empty());
    }

    private CollectionOptions(Integer size, Integer maxDocuments, Boolean capped, Optional<Collation> collation) {
        this.maxDocuments = maxDocuments;
        this.size = size;
        this.capped = capped;
        this.collation = collation;
    }

    private CollectionOptions() {
    }

    public static CollectionOptions just(Collation collation) {
        Assert.notNull((Object)collation, (String)"Collation must not be null!");
        CollectionOptions options = new CollectionOptions();
        options.setCollation(collation);
        return options;
    }

    public static CollectionOptions empty() {
        return new CollectionOptions();
    }

    public CollectionOptions capped(int size) {
        return new CollectionOptions(size, this.maxDocuments, true, this.collation);
    }

    public CollectionOptions maxDocuments(Integer maxDocuments) {
        return new CollectionOptions(this.size, maxDocuments, this.capped, this.collation);
    }

    public CollectionOptions size(int size) {
        return new CollectionOptions(size, this.maxDocuments, this.capped, this.collation);
    }

    public CollectionOptions collation(Collation collation) {
        return new CollectionOptions(this.size, this.maxDocuments, this.capped, Optional.ofNullable(collation));
    }

    public Integer getMaxDocuments() {
        return this.maxDocuments;
    }

    public void setMaxDocuments(Integer maxDocuments) {
        this.maxDocuments = maxDocuments;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Boolean getCapped() {
        return this.capped;
    }

    public void setCapped(Boolean capped) {
        this.capped = capped;
    }

    public void setCollation(Collation collation) {
        this.collation = Optional.ofNullable(collation);
    }

    public Optional<Collation> getCollation() {
        return this.collation;
    }
}

