/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import java.util.Optional;
import org.springframework.data.mongodb.core.Collation;

public class FindAndModifyOptions {
    private boolean returnNew;
    private boolean upsert;
    private boolean remove;
    private Collation collation;

    public static FindAndModifyOptions options() {
        return new FindAndModifyOptions();
    }

    public static FindAndModifyOptions of(FindAndModifyOptions source) {
        FindAndModifyOptions options = new FindAndModifyOptions();
        if (source == null) {
            return options;
        }
        options.returnNew = source.returnNew;
        options.upsert = source.upsert;
        options.remove = source.remove;
        options.collation = source.collation;
        return options;
    }

    public FindAndModifyOptions returnNew(boolean returnNew) {
        this.returnNew = returnNew;
        return this;
    }

    public FindAndModifyOptions upsert(boolean upsert) {
        this.upsert = upsert;
        return this;
    }

    public FindAndModifyOptions remove(boolean remove) {
        this.remove = remove;
        return this;
    }

    public FindAndModifyOptions collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    public boolean isReturnNew() {
        return this.returnNew;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public boolean isRemove() {
        return this.remove;
    }

    public Optional<Collation> getCollation() {
        return Optional.ofNullable(this.collation);
    }
}

