/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.BulkWriteException;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoException;
import com.mongodb.MongoServerException;
import com.mongodb.bulk.BulkWriteError;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.bson.BsonInvalidOperationException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.PermissionDeniedDataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.BulkOperationException;
import org.springframework.data.mongodb.UncategorizedMongoDbException;
import org.springframework.data.mongodb.util.MongoDbErrorCodes;
import org.springframework.util.ClassUtils;

public class MongoExceptionTranslator
implements PersistenceExceptionTranslator {
    private static final Set<String> DULICATE_KEY_EXCEPTIONS = new HashSet<String>(Arrays.asList("MongoException.DuplicateKey", "DuplicateKeyException"));
    private static final Set<String> RESOURCE_FAILURE_EXCEPTIONS = new HashSet<String>(Arrays.asList("MongoException.Network", "MongoSocketException", "MongoException.CursorNotFound", "MongoCursorNotFoundException", "MongoServerSelectionException", "MongoTimeoutException"));
    private static final Set<String> RESOURCE_USAGE_EXCEPTIONS = new HashSet<String>(Arrays.asList("MongoInternalException"));
    private static final Set<String> DATA_INTEGRETY_EXCEPTIONS = new HashSet<String>(Arrays.asList("WriteConcernException", "MongoWriteException", "MongoBulkWriteException"));

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof BsonInvalidOperationException) {
            throw new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        String exception = ClassUtils.getShortName((Class)ClassUtils.getUserClass(ex.getClass()));
        if (DULICATE_KEY_EXCEPTIONS.contains(exception)) {
            return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
        }
        if (RESOURCE_FAILURE_EXCEPTIONS.contains(exception)) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (RESOURCE_USAGE_EXCEPTIONS.contains(exception)) {
            return new InvalidDataAccessResourceUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (DATA_INTEGRETY_EXCEPTIONS.contains(exception)) {
            if (ex instanceof MongoServerException) {
                if (((MongoServerException)ex).getCode() == 11000) {
                    return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
                }
                if (ex instanceof MongoBulkWriteException) {
                    for (BulkWriteError x : ((MongoBulkWriteException)ex).getWriteErrors()) {
                        if (x.getCode() != 11000) continue;
                        return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof BulkWriteException) {
            return new BulkOperationException(ex.getMessage(), (BulkWriteException)((Object)ex));
        }
        if (ex instanceof MongoException) {
            int code = ((MongoException)ex).getCode();
            if (MongoDbErrorCodes.isDuplicateKeyCode(code)) {
                throw new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
            }
            if (MongoDbErrorCodes.isDataAccessResourceFailureCode(code)) {
                throw new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
            }
            if (MongoDbErrorCodes.isInvalidDataAccessApiUsageCode(code) || code == 10003 || code == 12001 || code == 12010 || code == 12011 || code == 12012) {
                throw new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
            }
            if (MongoDbErrorCodes.isPermissionDeniedCode(code)) {
                throw new PermissionDeniedDataAccessException(ex.getMessage(), (Throwable)ex);
            }
            return new UncategorizedMongoDbException(ex.getMessage(), ex);
        }
        return null;
    }
}

