/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.MongoException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.IndexOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.dao.DataAccessException;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.CollectionCallback;
import org.springframework.data.mongodb.core.IndexConverters;
import org.springframework.data.mongodb.core.IndexOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexInfo;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.util.Assert;

public class DefaultIndexOperations
implements IndexOperations {
    private static final String PARTIAL_FILTER_EXPRESSION_KEY = "partialFilterExpression";
    private final MongoDbFactory mongoDbFactory;
    private final String collectionName;
    private final QueryMapper mapper;
    private final Class<?> type;

    public DefaultIndexOperations(MongoDbFactory mongoDbFactory, String collectionName, QueryMapper queryMapper) {
        this(mongoDbFactory, collectionName, queryMapper, null);
    }

    public DefaultIndexOperations(MongoDbFactory mongoDbFactory, String collectionName, QueryMapper queryMapper, Class<?> type) {
        Assert.notNull((Object)mongoDbFactory, (String)"MongoDbFactory must not be null!");
        Assert.notNull((Object)collectionName, (String)"Collection name can not be null!");
        Assert.notNull((Object)queryMapper, (String)"QueryMapper must not be null!");
        this.mongoDbFactory = mongoDbFactory;
        this.collectionName = collectionName;
        this.mapper = queryMapper;
        this.type = type;
    }

    @Override
    public String ensureIndex(IndexDefinition indexDefinition) {
        return this.execute(collection -> {
            Document indexOptions = indexDefinition.getIndexOptions();
            if (indexOptions != null) {
                IndexOptions ops = (IndexOptions)IndexConverters.indexDefinitionToIndexOptionsConverter().convert((Object)indexDefinition);
                if (indexOptions.containsKey((Object)PARTIAL_FILTER_EXPRESSION_KEY)) {
                    Assert.isInstanceOf(Document.class, (Object)indexOptions.get((Object)PARTIAL_FILTER_EXPRESSION_KEY));
                    ops.partialFilterExpression((Bson)this.mapper.getMappedObject((Bson)((Document)indexOptions.get((Object)PARTIAL_FILTER_EXPRESSION_KEY)), this.lookupPersistentEntity(this.type, this.collectionName)));
                }
                return collection.createIndex((Bson)indexDefinition.getIndexKeys(), ops);
            }
            return collection.createIndex((Bson)indexDefinition.getIndexKeys());
        });
    }

    private MongoPersistentEntity<?> lookupPersistentEntity(Class<?> entityType, String collection) {
        if (entityType != null) {
            return (MongoPersistentEntity)this.mapper.getMappingContext().getRequiredPersistentEntity(entityType);
        }
        Collection entities = this.mapper.getMappingContext().getPersistentEntities();
        for (MongoPersistentEntity entity : entities) {
            if (!entity.getCollection().equals(collection)) continue;
            return entity;
        }
        return null;
    }

    @Override
    public void dropIndex(String name) {
        this.execute(collection -> {
            collection.dropIndex(name);
            return null;
        });
    }

    @Override
    public void dropAllIndexes() {
        this.dropIndex("*");
    }

    @Override
    public List<IndexInfo> getIndexInfo() {
        return this.execute(new CollectionCallback<List<IndexInfo>>(){

            @Override
            public List<IndexInfo> doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
                MongoCursor cursor = collection.listIndexes(Document.class).iterator();
                return this.getIndexData((MongoCursor<Document>)cursor);
            }

            private List<IndexInfo> getIndexData(MongoCursor<Document> cursor) {
                ArrayList<IndexInfo> indexInfoList = new ArrayList<IndexInfo>();
                while (cursor.hasNext()) {
                    Document ix = (Document)cursor.next();
                    IndexInfo indexInfo = (IndexInfo)IndexConverters.documentToIndexInfoConverter().convert((Object)ix);
                    indexInfoList.add(indexInfo);
                }
                return indexInfoList;
            }
        });
    }

    public <T> T execute(CollectionCallback<T> callback) {
        Assert.notNull(callback, (String)"CollectionCallback must not be null!");
        try {
            MongoCollection collection = this.mongoDbFactory.getDb().getCollection(this.collectionName);
            return callback.doInCollection((MongoCollection<Document>)collection);
        }
        catch (RuntimeException e) {
            throw MongoTemplate.potentiallyConvertRuntimeException(e, this.mongoDbFactory.getExceptionTranslator());
        }
    }
}

