/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.result.UpdateResult;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.bson.Document;
import org.springframework.data.mongodb.core.ExecutableUpdateOperation;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ExecutableUpdateOperationSupport
implements ExecutableUpdateOperation {
    private final MongoTemplate template;

    ExecutableUpdateOperationSupport(MongoTemplate template) {
        Assert.notNull((Object)template, (String)"Template must not be null!");
        this.template = template;
    }

    @Override
    public <T> ExecutableUpdateOperation.UpdateOperation<T> update(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new UpdateOperationSupport<T>(this.template, null, domainType, null, null, null);
    }

    static class UpdateOperationSupport<T>
    implements ExecutableUpdateOperation.UpdateOperation<T>,
    ExecutableUpdateOperation.UpdateOperationWithCollection<T>,
    ExecutableUpdateOperation.UpdateOperationWithQuery<T>,
    ExecutableUpdateOperation.TerminatingUpdateOperation<T> {
        private final MongoTemplate template;
        private final Query query;
        private final Class<T> domainType;
        private final Update update;
        private final String collection;
        private final FindAndModifyOptions options;

        @Override
        public ExecutableUpdateOperation.TerminatingUpdateOperation<T> apply(Update update) {
            Assert.notNull((Object)update, (String)"Update must not be null!");
            return new UpdateOperationSupport<T>(this.template, this.query, this.domainType, update, this.collection, this.options);
        }

        @Override
        public ExecutableUpdateOperation.UpdateOperationWithQuery<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty!");
            return new UpdateOperationSupport<T>(this.template, this.query, this.domainType, this.update, collection, this.options);
        }

        @Override
        public UpdateResult first() {
            return this.doUpdate(false, false);
        }

        @Override
        public UpdateResult upsert() {
            return this.doUpdate(true, true);
        }

        @Override
        public Optional<T> findAndModify() {
            String collectionName = this.getCollectionName();
            return Optional.ofNullable(this.template.findAndModify(this.query != null ? this.query : new BasicQuery(new Document()), this.update, this.options, this.domainType, collectionName));
        }

        @Override
        public ExecutableUpdateOperation.UpdateOperationWithUpdate<T> matching(Query query) {
            Assert.notNull((Object)query, (String)"Query must not be null!");
            return new UpdateOperationSupport<T>(this.template, query, this.domainType, this.update, this.collection, this.options);
        }

        @Override
        public UpdateResult all() {
            return this.doUpdate(true, false);
        }

        @Override
        public ExecutableUpdateOperation.TerminatingFindAndModifyOperation<T> withOptions(FindAndModifyOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null!");
            return new UpdateOperationSupport<T>(this.template, this.query, this.domainType, this.update, this.collection, options);
        }

        private UpdateResult doUpdate(boolean multi, boolean upsert) {
            String collectionName = this.getCollectionName();
            Query query = this.query != null ? this.query : new BasicQuery(new Document());
            return this.template.doUpdate(collectionName, query, this.update, this.domainType, upsert, multi);
        }

        private String getCollectionName() {
            return StringUtils.hasText((String)this.collection) ? this.collection : this.template.determineCollectionName(this.domainType);
        }

        @ConstructorProperties(value={"template", "query", "domainType", "update", "collection", "options"})
        public UpdateOperationSupport(MongoTemplate template, Query query, Class<T> domainType, Update update, String collection, FindAndModifyOptions options) {
            this.template = template;
            this.query = query;
            this.domainType = domainType;
            this.update = update;
            this.collection = collection;
            this.options = options;
        }
    }
}

