/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import com.mongodb.util.JSON;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bson.Document;
import org.springframework.core.convert.converter.Converter;

public abstract class SerializationUtils {
    private SerializationUtils() {
    }

    public static Map<String, Object> flattenMap(Document source) {
        if (source == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        SerializationUtils.toFlatMap("", source, result);
        return result;
    }

    private static void toFlatMap(String currentPath, Object source, Map<String, Object> map) {
        if (source instanceof Document) {
            String pathPrefix;
            Document document = (Document)source;
            Iterator iter = document.entrySet().iterator();
            String string = pathPrefix = currentPath.isEmpty() ? "" : currentPath + ".";
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                if (((String)entry.getKey()).startsWith("$")) {
                    if (map.containsKey(currentPath)) {
                        ((Document)map.get(currentPath)).put((String)entry.getKey(), entry.getValue());
                        continue;
                    }
                    map.put(currentPath, new Document((String)entry.getKey(), entry.getValue()));
                    continue;
                }
                SerializationUtils.toFlatMap(pathPrefix + (String)entry.getKey(), entry.getValue(), map);
            }
        } else {
            map.put(currentPath, source);
        }
    }

    public static String serializeToJsonSafely(Object value) {
        if (value == null) {
            return null;
        }
        try {
            return JSON.serialize((Object)value);
        }
        catch (Exception e) {
            if (value instanceof Collection) {
                return SerializationUtils.toString((Collection)value);
            }
            if (value instanceof Map) {
                return SerializationUtils.toString((Map)value);
            }
            if (value instanceof Document) {
                return SerializationUtils.toString((Document)value);
            }
            return String.format("{ $java : %s }", value.toString());
        }
    }

    private static String toString(Map<?, ?> source) {
        return SerializationUtils.iterableToDelimitedString(source.entrySet(), "{ ", " }", new Converter<Map.Entry<?, ?>, Object>(){

            public Object convert(Map.Entry<?, ?> source) {
                return String.format("\"%s\" : %s", source.getKey(), SerializationUtils.serializeToJsonSafely(source.getValue()));
            }
        });
    }

    private static String toString(Collection<?> source) {
        return SerializationUtils.iterableToDelimitedString(source, "[ ", " ]", new Converter<Object, Object>(){

            public Object convert(Object source) {
                return SerializationUtils.serializeToJsonSafely(source);
            }
        });
    }

    private static <T> String iterableToDelimitedString(Iterable<T> source, String prefix, String postfix, Converter<? super T, Object> transformer) {
        StringBuilder builder = new StringBuilder(prefix);
        Iterator<T> iterator = source.iterator();
        while (iterator.hasNext()) {
            builder.append(transformer.convert(iterator.next()));
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append(postfix).toString();
    }
}

