/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.ProcessBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.repository.cdi.MongoRepositoryBean;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.repository.cdi.CdiRepositoryExtensionSupport;

public class MongoRepositoryExtension
extends CdiRepositoryExtensionSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MongoRepositoryExtension.class);
    private final Map<Set<Annotation>, Bean<MongoOperations>> mongoOperations = new HashMap<Set<Annotation>, Bean<MongoOperations>>();

    public MongoRepositoryExtension() {
        LOG.info("Activating CDI extension for Spring Data MongoDB repositories.");
    }

    <X> void processBean(@Observes ProcessBean<X> processBean) {
        Bean bean = processBean.getBean();
        for (Type type : bean.getTypes()) {
            if (!(type instanceof Class) || !MongoOperations.class.isAssignableFrom((Class)type)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Discovered %s with qualifiers %s.", MongoOperations.class.getName(), bean.getQualifiers()));
            }
            this.mongoOperations.put(new HashSet(bean.getQualifiers()), (Bean<MongoOperations>)bean);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (Map.Entry entry : this.getRepositoryTypes()) {
            Class repositoryType = (Class)entry.getKey();
            Set qualifiers = (Set)entry.getValue();
            CdiRepositoryBean repositoryBean = this.createRepositoryBean(repositoryType, qualifiers, beanManager);
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("Registering bean for %s with qualifiers %s.", repositoryType.getName(), qualifiers));
            }
            this.registerBean(repositoryBean);
            afterBeanDiscovery.addBean(repositoryBean);
        }
    }

    private <T> CdiRepositoryBean<T> createRepositoryBean(Class<T> repositoryType, Set<Annotation> qualifiers, BeanManager beanManager) {
        Bean<MongoOperations> mongoOperations = this.mongoOperations.get(qualifiers);
        if (mongoOperations == null) {
            throw new UnsatisfiedResolutionException(String.format("Unable to resolve a bean for '%s' with qualifiers %s.", MongoOperations.class.getName(), qualifiers));
        }
        return new MongoRepositoryBean<T>(mongoOperations, qualifiers, repositoryType, beanManager, Optional.ofNullable(this.getCustomImplementationDetector()));
    }
}

