/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import com.google.common.base.Function;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.querydsl.mongodb.AbstractMongodbQuery;
import com.querydsl.mongodb.MongodbSerializer;
import java.util.Map;
import org.bson.Document;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.repository.support.SpringDataMongodbSerializer;

public class SpringDataMongodbQuery<T>
extends AbstractMongodbQuery<T, SpringDataMongodbQuery<T>> {
    private final MongoOperations operations;

    public SpringDataMongodbQuery(MongoOperations operations, Class<? extends T> type) {
        this(operations, type, operations.getCollectionName(type));
    }

    public SpringDataMongodbQuery(final MongoOperations operations, final Class<? extends T> type, String collectionName) {
        super(((MongoTemplate)operations).getMongoDbFactory().getLegacyDb().getCollection(collectionName), new Function<DBObject, T>(){

            public T apply(DBObject input) {
                return operations.getConverter().read(type, new Document((Map)((BasicDBObject)input)));
            }
        }, (MongodbSerializer)new SpringDataMongodbSerializer(operations.getConverter()));
        this.operations = operations;
    }

    protected DBCollection getCollection(Class<?> type) {
        return ((MongoTemplate)this.operations).getMongoDbFactory().getLegacyDb().getCollection(this.operations.getCollectionName(type));
    }
}

