/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import com.mongodb.DBRef;
import com.querydsl.core.types.Constant;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathType;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.TemplateExpression;
import com.querydsl.core.types.Visitor;
import com.querydsl.mongodb.MongodbOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bson.BsonJavaScript;
import org.bson.BsonRegularExpression;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.repository.support.QuerydslMongoOps;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

abstract class MongodbDocumentSerializer
implements Visitor<Object, Void> {
    MongodbDocumentSerializer() {
    }

    @Nullable
    Object handle(Expression<?> expression) {
        return expression.accept((Visitor)this, null);
    }

    Document toQuery(Predicate predicate) {
        Object value = this.handle((Expression<?>)predicate);
        if (value == null) {
            return new Document();
        }
        Assert.isInstanceOf(Document.class, (Object)value, () -> String.format("Invalid type. Expected Document but found %s", value.getClass()));
        return (Document)value;
    }

    Document toSort(List<OrderSpecifier<?>> orderBys) {
        Document sort = new Document();
        orderBys.forEach(orderSpecifier -> {
            Object key = orderSpecifier.getTarget().accept((Visitor)this, null);
            Assert.notNull((Object)key, () -> String.format("Mapped sort key for %s must not be null!", orderSpecifier));
            sort.append(key.toString(), (Object)(orderSpecifier.getOrder() == Order.ASC ? 1 : -1));
        });
        return sort;
    }

    public Object visit(Constant<?> expr, Void context) {
        if (!Enum.class.isAssignableFrom(expr.getType())) {
            return expr.getConstant();
        }
        Constant<?> expectedExpr = expr;
        return ((Enum)expectedExpr.getConstant()).name();
    }

    public Object visit(TemplateExpression<?> expr, Void context) {
        throw new UnsupportedOperationException();
    }

    public Object visit(FactoryExpression<?> expr, Void context) {
        throw new UnsupportedOperationException();
    }

    protected String asDBKey(Operation<?> expr, int index) {
        String key = (String)this.asDBValue(expr, index);
        Assert.hasText((String)key, () -> String.format("Mapped key must not be null nor empty for expression %s.", expr));
        return key;
    }

    @Nullable
    protected Object asDBValue(Operation<?> expr, int index) {
        return expr.getArg(index).accept((Visitor)this, null);
    }

    private String regexValue(Operation<?> expr, int index) {
        Object value = expr.getArg(index).accept((Visitor)this, null);
        Assert.notNull((Object)value, () -> String.format("Regex for %s must not be null.", expr));
        return Pattern.quote(value.toString());
    }

    protected Document asDocument(String key, @Nullable Object value) {
        return new Document(key, value);
    }

    public Object visit(Operation<?> expr, Void context) {
        Operator op = expr.getOperator();
        if (op == Ops.EQ) {
            if (expr.getArg(0) instanceof Operation) {
                Operation lhs = (Operation)expr.getArg(0);
                if (lhs.getOperator() == Ops.COL_SIZE || lhs.getOperator() == Ops.ARRAY_SIZE) {
                    return this.asDocument(this.asDBKey(lhs, 0), this.asDocument("$size", this.asDBValue(expr, 1)));
                }
                throw new UnsupportedOperationException("Illegal operation " + expr);
            }
            if (expr.getArg(0) instanceof Path) {
                Path path = (Path)expr.getArg(0);
                Constant constant = (Constant)expr.getArg(1);
                return this.asDocument(this.asDBKey(expr, 0), this.convert(path, constant));
            }
        } else {
            if (op == Ops.STRING_IS_EMPTY) {
                return this.asDocument(this.asDBKey(expr, 0), "");
            }
            if (op == Ops.AND) {
                Map lhs = (Map)this.handle(expr.getArg(0));
                Map rhs = (Map)this.handle(expr.getArg(1));
                LinkedHashSet lhs2 = new LinkedHashSet(lhs.entrySet());
                lhs2.retainAll(rhs.entrySet());
                if (lhs2.isEmpty()) {
                    lhs.putAll(rhs);
                    return lhs;
                }
                ArrayList<Object> list = new ArrayList<Object>(2);
                list.add(this.handle(expr.getArg(0)));
                list.add(this.handle(expr.getArg(1)));
                return this.asDocument("$and", list);
            }
            if (op == Ops.NOT) {
                Operation subOperation = (Operation)expr.getArg(0);
                Operator subOp = subOperation.getOperator();
                if (subOp == Ops.IN) {
                    return this.visit(ExpressionUtils.operation(Boolean.class, (Operator)Ops.NOT_IN, (Expression[])new Expression[]{subOperation.getArg(0), subOperation.getArg(1)}), context);
                }
                Document arg = (Document)this.handle(expr.getArg(0));
                return this.negate(arg);
            }
            if (op == Ops.OR) {
                ArrayList<Object> list = new ArrayList<Object>(2);
                list.add(this.handle(expr.getArg(0)));
                list.add(this.handle(expr.getArg(1)));
                return this.asDocument("$or", list);
            }
            if (op == Ops.NE) {
                Path path = (Path)expr.getArg(0);
                Constant constant = (Constant)expr.getArg(1);
                return this.asDocument(this.asDBKey(expr, 0), this.asDocument("$ne", this.convert(path, constant)));
            }
            if (op == Ops.STARTS_WITH) {
                return this.asDocument(this.asDBKey(expr, 0), new BsonRegularExpression("^" + this.regexValue(expr, 1)));
            }
            if (op == Ops.STARTS_WITH_IC) {
                return this.asDocument(this.asDBKey(expr, 0), new BsonRegularExpression("^" + this.regexValue(expr, 1), "i"));
            }
            if (op == Ops.ENDS_WITH) {
                return this.asDocument(this.asDBKey(expr, 0), new BsonRegularExpression(this.regexValue(expr, 1) + "$"));
            }
            if (op == Ops.ENDS_WITH_IC) {
                return this.asDocument(this.asDBKey(expr, 0), new BsonRegularExpression(this.regexValue(expr, 1) + "$", "i"));
            }
            if (op == Ops.EQ_IGNORE_CASE) {
                return this.asDocument(this.asDBKey(expr, 0), new BsonRegularExpression("^" + this.regexValue(expr, 1) + "$", "i"));
            }
            if (op == Ops.STRING_CONTAINS) {
                return this.asDocument(this.asDBKey(expr, 0), new BsonRegularExpression(".*" + this.regexValue(expr, 1) + ".*"));
            }
            if (op == Ops.STRING_CONTAINS_IC) {
                return this.asDocument(this.asDBKey(expr, 0), new BsonRegularExpression(".*" + this.regexValue(expr, 1) + ".*", "i"));
            }
            if (op == Ops.MATCHES) {
                return this.asDocument(this.asDBKey(expr, 0), new BsonRegularExpression(this.asDBValue(expr, 1).toString()));
            }
            if (op == Ops.MATCHES_IC) {
                return this.asDocument(this.asDBKey(expr, 0), new BsonRegularExpression(this.asDBValue(expr, 1).toString(), "i"));
            }
            if (op == Ops.LIKE) {
                String regex = ExpressionUtils.likeToRegex((Expression)expr.getArg(1)).toString();
                return this.asDocument(this.asDBKey(expr, 0), new BsonRegularExpression(regex));
            }
            if (op == Ops.BETWEEN) {
                Document value = new Document("$gte", this.asDBValue(expr, 1));
                value.append("$lte", this.asDBValue(expr, 2));
                return this.asDocument(this.asDBKey(expr, 0), value);
            }
            if (op == Ops.IN) {
                int constIndex = 0;
                int exprIndex = 1;
                if (expr.getArg(1) instanceof Constant) {
                    constIndex = 1;
                    exprIndex = 0;
                }
                if (Collection.class.isAssignableFrom(expr.getArg(constIndex).getType())) {
                    Collection values = (Collection)((Constant)expr.getArg(constIndex)).getConstant();
                    return this.asDocument(this.asDBKey(expr, exprIndex), this.asDocument("$in", values));
                }
                Path path = (Path)expr.getArg(exprIndex);
                Constant constant = (Constant)expr.getArg(constIndex);
                return this.asDocument(this.asDBKey(expr, exprIndex), this.convert(path, constant));
            }
            if (op == Ops.NOT_IN) {
                int constIndex = 0;
                int exprIndex = 1;
                if (expr.getArg(1) instanceof Constant) {
                    constIndex = 1;
                    exprIndex = 0;
                }
                if (Collection.class.isAssignableFrom(expr.getArg(constIndex).getType())) {
                    Collection values = (Collection)((Constant)expr.getArg(constIndex)).getConstant();
                    return this.asDocument(this.asDBKey(expr, exprIndex), this.asDocument("$nin", values));
                }
                Path path = (Path)expr.getArg(exprIndex);
                Constant constant = (Constant)expr.getArg(constIndex);
                return this.asDocument(this.asDBKey(expr, exprIndex), this.asDocument("$ne", this.convert(path, constant)));
            }
            if (op == Ops.COL_IS_EMPTY) {
                ArrayList<Document> list = new ArrayList<Document>(2);
                list.add(this.asDocument(this.asDBKey(expr, 0), new ArrayList()));
                list.add(this.asDocument(this.asDBKey(expr, 0), this.asDocument("$exists", false)));
                return this.asDocument("$or", list);
            }
            if (op == Ops.LT) {
                return this.asDocument(this.asDBKey(expr, 0), this.asDocument("$lt", this.asDBValue(expr, 1)));
            }
            if (op == Ops.GT) {
                return this.asDocument(this.asDBKey(expr, 0), this.asDocument("$gt", this.asDBValue(expr, 1)));
            }
            if (op == Ops.LOE) {
                return this.asDocument(this.asDBKey(expr, 0), this.asDocument("$lte", this.asDBValue(expr, 1)));
            }
            if (op == Ops.GOE) {
                return this.asDocument(this.asDBKey(expr, 0), this.asDocument("$gte", this.asDBValue(expr, 1)));
            }
            if (op == Ops.IS_NULL) {
                return this.asDocument(this.asDBKey(expr, 0), this.asDocument("$exists", false));
            }
            if (op == Ops.IS_NOT_NULL) {
                return this.asDocument(this.asDBKey(expr, 0), this.asDocument("$exists", true));
            }
            if (op == Ops.CONTAINS_KEY) {
                Path path = (Path)expr.getArg(0);
                Expression key = expr.getArg(1);
                return this.asDocument(this.visit(path, context) + "." + key.toString(), this.asDocument("$exists", true));
            }
            if (op == MongodbOps.NEAR) {
                return this.asDocument(this.asDBKey(expr, 0), this.asDocument("$near", this.asDBValue(expr, 1)));
            }
            if (op == MongodbOps.NEAR_SPHERE) {
                return this.asDocument(this.asDBKey(expr, 0), this.asDocument("$nearSphere", this.asDBValue(expr, 1)));
            }
            if (op == MongodbOps.ELEM_MATCH) {
                return this.asDocument(this.asDBKey(expr, 0), this.asDocument("$elemMatch", this.asDBValue(expr, 1)));
            }
            if (op == QuerydslMongoOps.NO_MATCH) {
                return new Document("$where", (Object)new BsonJavaScript("function() { return false }"));
            }
        }
        throw new UnsupportedOperationException("Illegal operation " + expr);
    }

    private Object negate(Document arg) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Map.Entry entry : arg.entrySet()) {
            if (((String)entry.getKey()).equals("$or")) {
                list.add(this.asDocument("$nor", entry.getValue()));
                continue;
            }
            if (((String)entry.getKey()).equals("$and")) {
                ArrayList<Object> list2 = new ArrayList<Object>();
                for (Object o : (Collection)entry.getValue()) {
                    list2.add(this.negate((Document)o));
                }
                list.add(this.asDocument("$or", list2));
                continue;
            }
            if (entry.getValue() instanceof Pattern || entry.getValue() instanceof BsonRegularExpression) {
                list.add(this.asDocument((String)entry.getKey(), this.asDocument("$not", entry.getValue())));
                continue;
            }
            if (entry.getValue() instanceof Document) {
                list.add(this.negate((String)entry.getKey(), (Document)entry.getValue()));
                continue;
            }
            list.add(this.asDocument((String)entry.getKey(), this.asDocument("$ne", entry.getValue())));
        }
        return list.size() == 1 ? list.get(0) : this.asDocument("$or", list);
    }

    private Object negate(String key, Document value) {
        if (value.size() == 1) {
            return this.asDocument(key, this.asDocument("$not", value));
        }
        ArrayList<Document> list2 = new ArrayList<Document>();
        for (Map.Entry entry2 : value.entrySet()) {
            list2.add(this.asDocument(key, this.asDocument("$not", this.asDocument((String)entry2.getKey(), entry2.getValue()))));
        }
        return this.asDocument("$or", list2);
    }

    protected Object convert(Path<?> property, Constant<?> constant) {
        if (this.isReference(property)) {
            return this.asReference(constant.getConstant());
        }
        if (this.isId(property)) {
            if (this.isReference(property.getMetadata().getParent())) {
                return this.asReferenceKey(property.getMetadata().getParent().getType(), constant.getConstant());
            }
            if (constant.getType().equals(String.class) && this.isImplicitObjectIdConversion()) {
                String id = (String)constant.getConstant();
                return ObjectId.isValid((String)id) ? new ObjectId(id) : id;
            }
        }
        return this.visit(constant, null);
    }

    protected boolean isImplicitObjectIdConversion() {
        return true;
    }

    protected DBRef asReferenceKey(Class<?> entity, Object id) {
        throw new UnsupportedOperationException();
    }

    protected abstract DBRef asReference(Object var1);

    protected abstract boolean isReference(@Nullable Path<?> var1);

    protected boolean isId(Path<?> arg) {
        return false;
    }

    public String visit(Path<?> expr, Void context) {
        PathMetadata metadata = expr.getMetadata();
        if (metadata.getParent() != null) {
            Path parent = metadata.getParent();
            if (parent.getMetadata().getPathType() == PathType.DELEGATE) {
                parent = parent.getMetadata().getParent();
            }
            if (metadata.getPathType() == PathType.COLLECTION_ANY) {
                return this.visit(parent, context);
            }
            if (parent.getMetadata().getPathType() != PathType.VARIABLE) {
                String rv = this.getKeyForPath(expr, metadata);
                String parentStr = this.visit(parent, context);
                return rv != null ? parentStr + "." + rv : parentStr;
            }
        }
        return this.getKeyForPath(expr, metadata);
    }

    protected String getKeyForPath(Path<?> expr, PathMetadata metadata) {
        return metadata.getElement().toString();
    }

    public Object visit(SubQueryExpression<?> expr, Void context) {
        throw new UnsupportedOperationException();
    }

    public Object visit(ParamExpression<?> expr, Void context) {
        throw new UnsupportedOperationException();
    }
}

