/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.model.changestream.FullDocument;
import java.time.Instant;
import java.util.Arrays;
import java.util.Optional;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class ChangeStreamOptions {
    @Nullable
    private Object filter;
    @Nullable
    private BsonValue resumeToken;
    @Nullable
    private FullDocument fullDocumentLookup;
    @Nullable
    private Collation collation;
    @Nullable
    private Object resumeTimestamp;

    protected ChangeStreamOptions() {
    }

    public Optional<Object> getFilter() {
        return Optional.ofNullable(this.filter);
    }

    public Optional<BsonValue> getResumeToken() {
        return Optional.ofNullable(this.resumeToken);
    }

    public Optional<FullDocument> getFullDocumentLookup() {
        return Optional.ofNullable(this.fullDocumentLookup);
    }

    public Optional<Collation> getCollation() {
        return Optional.ofNullable(this.collation);
    }

    public Optional<Instant> getResumeTimestamp() {
        return Optional.ofNullable(this.resumeTimestamp).map(timestamp -> ChangeStreamOptions.asTimestampOfType(timestamp, Instant.class));
    }

    public Optional<BsonTimestamp> getResumeBsonTimestamp() {
        return Optional.ofNullable(this.resumeTimestamp).map(timestamp -> ChangeStreamOptions.asTimestampOfType(timestamp, BsonTimestamp.class));
    }

    public static ChangeStreamOptions empty() {
        return ChangeStreamOptions.builder().build();
    }

    public static ChangeStreamOptionsBuilder builder() {
        return new ChangeStreamOptionsBuilder();
    }

    private static <T> T asTimestampOfType(Object timestamp, Class<T> targetType) {
        return targetType.cast(ChangeStreamOptions.doGetTimestamp(timestamp, targetType));
    }

    private static <T> Object doGetTimestamp(Object timestamp, Class<T> targetType) {
        if (ClassUtils.isAssignableValue(targetType, (Object)timestamp)) {
            return timestamp;
        }
        if (timestamp instanceof Instant) {
            return new BsonTimestamp((int)((Instant)timestamp).getEpochSecond(), 0);
        }
        if (timestamp instanceof BsonTimestamp) {
            return Instant.ofEpochSecond(((BsonTimestamp)timestamp).getTime());
        }
        throw new IllegalArgumentException("o_O that should actually not happen. The timestamp should be an Instant or a BsonTimestamp but was " + ObjectUtils.nullSafeClassName((Object)timestamp));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeStreamOptions)) {
            return false;
        }
        ChangeStreamOptions other = (ChangeStreamOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Optional<Object> this$filter = this.getFilter();
        Optional<Object> other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter)) {
            return false;
        }
        Optional<BsonValue> this$resumeToken = this.getResumeToken();
        Optional<BsonValue> other$resumeToken = other.getResumeToken();
        if (this$resumeToken == null ? other$resumeToken != null : !((Object)this$resumeToken).equals(other$resumeToken)) {
            return false;
        }
        Optional<FullDocument> this$fullDocumentLookup = this.getFullDocumentLookup();
        Optional<FullDocument> other$fullDocumentLookup = other.getFullDocumentLookup();
        if (this$fullDocumentLookup == null ? other$fullDocumentLookup != null : !((Object)this$fullDocumentLookup).equals(other$fullDocumentLookup)) {
            return false;
        }
        Optional<Collation> this$collation = this.getCollation();
        Optional<Collation> other$collation = other.getCollation();
        if (this$collation == null ? other$collation != null : !((Object)this$collation).equals(other$collation)) {
            return false;
        }
        Optional<Instant> this$resumeTimestamp = this.getResumeTimestamp();
        Optional<Instant> other$resumeTimestamp = other.getResumeTimestamp();
        return !(this$resumeTimestamp == null ? other$resumeTimestamp != null : !((Object)this$resumeTimestamp).equals(other$resumeTimestamp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChangeStreamOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<Object> $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
        Optional<BsonValue> $resumeToken = this.getResumeToken();
        result = result * 59 + ($resumeToken == null ? 43 : ((Object)$resumeToken).hashCode());
        Optional<FullDocument> $fullDocumentLookup = this.getFullDocumentLookup();
        result = result * 59 + ($fullDocumentLookup == null ? 43 : ((Object)$fullDocumentLookup).hashCode());
        Optional<Collation> $collation = this.getCollation();
        result = result * 59 + ($collation == null ? 43 : ((Object)$collation).hashCode());
        Optional<Instant> $resumeTimestamp = this.getResumeTimestamp();
        result = result * 59 + ($resumeTimestamp == null ? 43 : ((Object)$resumeTimestamp).hashCode());
        return result;
    }

    public static class ChangeStreamOptionsBuilder {
        @Nullable
        private Object filter;
        @Nullable
        private BsonValue resumeToken;
        @Nullable
        private FullDocument fullDocumentLookup;
        @Nullable
        private Collation collation;
        @Nullable
        private Object resumeTimestamp;

        private ChangeStreamOptionsBuilder() {
        }

        public ChangeStreamOptionsBuilder collation(Collation collation) {
            Assert.notNull((Object)collation, (String)"Collation must not be null nor empty!");
            this.collation = collation;
            return this;
        }

        public ChangeStreamOptionsBuilder filter(Aggregation filter) {
            Assert.notNull((Object)filter, (String)"Filter must not be null!");
            this.filter = filter;
            return this;
        }

        public ChangeStreamOptionsBuilder filter(Document ... filter) {
            Assert.noNullElements((Object[])filter, (String)"Filter must not contain null values");
            this.filter = Arrays.asList(filter);
            return this;
        }

        public ChangeStreamOptionsBuilder resumeToken(BsonValue resumeToken) {
            Assert.notNull((Object)resumeToken, (String)"ResumeToken must not be null!");
            this.resumeToken = resumeToken;
            return this;
        }

        public ChangeStreamOptionsBuilder returnFullDocumentOnUpdate() {
            return this.fullDocumentLookup(FullDocument.UPDATE_LOOKUP);
        }

        public ChangeStreamOptionsBuilder fullDocumentLookup(FullDocument lookup) {
            Assert.notNull((Object)lookup, (String)"Lookup must not be null!");
            this.fullDocumentLookup = lookup;
            return this;
        }

        public ChangeStreamOptionsBuilder resumeAt(Instant resumeTimestamp) {
            Assert.notNull((Object)resumeTimestamp, (String)"ResumeTimestamp must not be null!");
            this.resumeTimestamp = resumeTimestamp;
            return this;
        }

        public ChangeStreamOptionsBuilder resumeAt(BsonTimestamp resumeTimestamp) {
            Assert.notNull((Object)resumeTimestamp, (String)"ResumeTimestamp must not be null!");
            this.resumeTimestamp = resumeTimestamp;
            return this;
        }

        public ChangeStreamOptions build() {
            ChangeStreamOptions options = new ChangeStreamOptions();
            options.filter = this.filter;
            options.resumeToken = this.resumeToken;
            options.fullDocumentLookup = this.fullDocumentLookup;
            options.collation = this.collation;
            options.resumeTimestamp = this.resumeTimestamp;
            return options;
        }
    }
}

