/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.schema;

import org.springframework.data.mongodb.core.schema.IdentifiableJsonSchemaProperty;
import org.springframework.data.mongodb.core.schema.JsonSchemaObject;
import org.springframework.data.mongodb.core.schema.TypedJsonSchemaObject;
import org.springframework.data.mongodb.core.schema.UntypedJsonSchemaObject;
import org.springframework.lang.Nullable;

public interface JsonSchemaProperty
extends JsonSchemaObject {
    public String getIdentifier();

    default public boolean isRequired() {
        return false;
    }

    public static IdentifiableJsonSchemaProperty.UntypedJsonSchemaProperty untyped(String identifier) {
        return new IdentifiableJsonSchemaProperty.UntypedJsonSchemaProperty(identifier, JsonSchemaObject.untyped());
    }

    public static IdentifiableJsonSchemaProperty.StringJsonSchemaProperty string(String identifier) {
        return new IdentifiableJsonSchemaProperty.StringJsonSchemaProperty(identifier, JsonSchemaObject.string());
    }

    public static IdentifiableJsonSchemaProperty.ObjectJsonSchemaProperty object(String identifier) {
        return new IdentifiableJsonSchemaProperty.ObjectJsonSchemaProperty(identifier, JsonSchemaObject.object());
    }

    public static IdentifiableJsonSchemaProperty.NumericJsonSchemaProperty number(String identifier) {
        return new IdentifiableJsonSchemaProperty.NumericJsonSchemaProperty(identifier, JsonSchemaObject.number());
    }

    public static IdentifiableJsonSchemaProperty.NumericJsonSchemaProperty int32(String identifier) {
        return new IdentifiableJsonSchemaProperty.NumericJsonSchemaProperty(identifier, new TypedJsonSchemaObject.NumericJsonSchemaObject(JsonSchemaObject.Type.intType()));
    }

    public static IdentifiableJsonSchemaProperty.NumericJsonSchemaProperty int64(String identifier) {
        return new IdentifiableJsonSchemaProperty.NumericJsonSchemaProperty(identifier, new TypedJsonSchemaObject.NumericJsonSchemaObject(JsonSchemaObject.Type.longType()));
    }

    public static IdentifiableJsonSchemaProperty.NumericJsonSchemaProperty float64(String identifier) {
        return new IdentifiableJsonSchemaProperty.NumericJsonSchemaProperty(identifier, new TypedJsonSchemaObject.NumericJsonSchemaObject(JsonSchemaObject.Type.doubleType()));
    }

    public static IdentifiableJsonSchemaProperty.NumericJsonSchemaProperty decimal128(String identifier) {
        return new IdentifiableJsonSchemaProperty.NumericJsonSchemaProperty(identifier, new TypedJsonSchemaObject.NumericJsonSchemaObject(JsonSchemaObject.Type.bigDecimalType()));
    }

    public static IdentifiableJsonSchemaProperty.ArrayJsonSchemaProperty array(String identifier) {
        return new IdentifiableJsonSchemaProperty.ArrayJsonSchemaProperty(identifier, JsonSchemaObject.array());
    }

    public static IdentifiableJsonSchemaProperty.BooleanJsonSchemaProperty bool(String identifier) {
        return new IdentifiableJsonSchemaProperty.BooleanJsonSchemaProperty(identifier, JsonSchemaObject.bool());
    }

    public static IdentifiableJsonSchemaProperty.NullJsonSchemaProperty nil(String identifier) {
        return new IdentifiableJsonSchemaProperty.NullJsonSchemaProperty(identifier, JsonSchemaObject.nil());
    }

    public static IdentifiableJsonSchemaProperty.DateJsonSchemaProperty date(String identifier) {
        return new IdentifiableJsonSchemaProperty.DateJsonSchemaProperty(identifier, JsonSchemaObject.date());
    }

    public static IdentifiableJsonSchemaProperty.TimestampJsonSchemaProperty timestamp(String identifier) {
        return new IdentifiableJsonSchemaProperty.TimestampJsonSchemaProperty(identifier, JsonSchemaObject.timestamp());
    }

    public static JsonSchemaPropertyBuilder named(String identifier) {
        return new JsonSchemaPropertyBuilder(identifier);
    }

    public static JsonSchemaProperty required(JsonSchemaProperty property) {
        return new IdentifiableJsonSchemaProperty.RequiredJsonSchemaProperty(property, true);
    }

    public static class JsonSchemaPropertyBuilder {
        private final String identifier;

        public IdentifiableJsonSchemaProperty<TypedJsonSchemaObject> ofType(JsonSchemaObject.Type type) {
            return new IdentifiableJsonSchemaProperty<TypedJsonSchemaObject>(this.identifier, TypedJsonSchemaObject.of(new JsonSchemaObject.Type[]{type}));
        }

        public IdentifiableJsonSchemaProperty<TypedJsonSchemaObject> ofType(@Nullable Class<?> type) {
            return new IdentifiableJsonSchemaProperty<TypedJsonSchemaObject>(this.identifier, JsonSchemaObject.of(type));
        }

        public IdentifiableJsonSchemaProperty<TypedJsonSchemaObject> with(TypedJsonSchemaObject schemaObject) {
            return new IdentifiableJsonSchemaProperty<TypedJsonSchemaObject>(this.identifier, schemaObject);
        }

        public IdentifiableJsonSchemaProperty<UntypedJsonSchemaObject> withoutType() {
            return new IdentifiableJsonSchemaProperty<UntypedJsonSchemaObject>(this.identifier, UntypedJsonSchemaObject.newInstance());
        }

        JsonSchemaPropertyBuilder(String identifier) {
            this.identifier = identifier;
        }
    }
}

