/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.gridfs;

import com.mongodb.client.gridfs.model.GridFSFile;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.reactivestreams.Publisher;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;

public class ReactiveGridFsResource
extends AbstractResource {
    static final String CONTENT_TYPE_FIELD = "_contentType";
    private static final ByteArrayInputStream EMPTY_INPUT_STREAM = new ByteArrayInputStream(new byte[0]);
    @Nullable
    private final GridFSFile file;
    private final String filename;
    private final Flux<DataBuffer> content;

    private ReactiveGridFsResource(String filename, Publisher<DataBuffer> content) {
        this.file = null;
        this.filename = filename;
        this.content = Flux.from(content);
    }

    public ReactiveGridFsResource(GridFSFile file, Publisher<DataBuffer> content) {
        this.file = file;
        this.filename = file.getFilename();
        this.content = Flux.from(content);
    }

    public static ReactiveGridFsResource absent(String filename) {
        Assert.notNull((Object)filename, (String)"Filename must not be null");
        return new ReactiveGridFsResource(filename, (Publisher<DataBuffer>)Flux.empty());
    }

    public InputStream getInputStream() throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public long contentLength() throws IOException {
        this.verifyExists();
        return this.file.getLength();
    }

    public String getFilename() throws IllegalStateException {
        return this.filename;
    }

    public boolean exists() {
        return this.file != null;
    }

    public long lastModified() throws IOException {
        this.verifyExists();
        return this.file.getUploadDate().getTime();
    }

    public String getDescription() {
        return String.format("GridFs resource [%s]", this.getFilename());
    }

    public Object getId() {
        Assert.state((boolean)this.exists(), () -> String.format("%s does not exist.", this.getDescription()));
        return this.file.getId();
    }

    public Flux<DataBuffer> getDownloadStream() {
        if (!this.exists()) {
            return Flux.error((Throwable)new FileNotFoundException(String.format("%s does not exist.", this.getDescription())));
        }
        return this.content;
    }

    private void verifyExists() throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException(String.format("%s does not exist.", this.getDescription()));
        }
    }
}

