/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.bson.Document;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameters;
import org.springframework.data.mongodb.util.json.ParameterBindingContext;
import org.springframework.data.mongodb.util.json.ParameterBindingDocumentCodec;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.NumberUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class QueryUtils {
    private static final ParameterBindingDocumentCodec CODEC = new ParameterBindingDocumentCodec();
    private static final Pattern PARAMETER_BINDING_PATTERN = Pattern.compile("\\?(\\d+)");

    QueryUtils() {
    }

    static Query decorateSort(Query query, Document defaultSort) {
        if (defaultSort.isEmpty()) {
            return query;
        }
        ProxyFactory factory = new ProxyFactory((Object)query);
        factory.addAdvice((Advice)((MethodInterceptor)invocation -> {
            if (!invocation.getMethod().getName().equals("getSortObject")) {
                return invocation.proceed();
            }
            Document combinedSort = new Document((Map)defaultSort);
            combinedSort.putAll((Map)((Document)invocation.proceed()));
            return combinedSort;
        }));
        return (Query)factory.getProxy();
    }

    static Query applyCollation(Query query, @Nullable String collationExpression, ConvertingParameterAccessor accessor, MongoParameters parameters, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        if (accessor.getCollation() != null) {
            return query.collation(accessor.getCollation());
        }
        if (collationExpression == null) {
            return query;
        }
        if (StringUtils.trimLeadingWhitespace((String)collationExpression).startsWith("{")) {
            ParameterBindingContext bindingContext = new ParameterBindingContext(accessor::getBindableValue, expressionParser, evaluationContextProvider.getEvaluationContext((Parameters)parameters, accessor.getValues()));
            return query.collation(Collation.from(CODEC.decode(collationExpression, bindingContext)));
        }
        Matcher matcher = PARAMETER_BINDING_PATTERN.matcher(collationExpression);
        if (!matcher.find()) {
            return query.collation(Collation.parse(collationExpression));
        }
        String placeholder = matcher.group();
        Object placeholderValue = accessor.getBindableValue(QueryUtils.computeParameterIndex(placeholder));
        if (collationExpression.startsWith("?")) {
            if (placeholderValue instanceof String) {
                return query.collation(Collation.parse(placeholderValue.toString()));
            }
            if (placeholderValue instanceof Locale) {
                return query.collation(Collation.of((Locale)placeholderValue));
            }
            if (placeholderValue instanceof Document) {
                return query.collation(Collation.from((Document)placeholderValue));
            }
            throw new IllegalArgumentException(String.format("Collation must be a String, Locale or Document but was %s", ObjectUtils.nullSafeClassName((Object)placeholderValue)));
        }
        return query.collation(Collation.parse(collationExpression.replace(placeholder, placeholderValue.toString())));
    }

    private static int computeParameterIndex(String parameter) {
        return (Integer)NumberUtils.parseNumber((String)parameter.replace("?", ""), Integer.class);
    }
}

