/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.aspects.support;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.Before;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.neo4j.aspects.FriendshipRepository;
import org.springframework.data.neo4j.aspects.GroupRepository;
import org.springframework.data.neo4j.aspects.PersonRepository;
import org.springframework.data.neo4j.aspects.support.TestTeam;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.StoredEntityType;
import org.springframework.data.neo4j.support.node.Neo4jHelper;
import org.springframework.test.context.transaction.BeforeTransaction;

public class EntityTestBase {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected Neo4jTemplate neo4jTemplate;
    @Autowired
    protected ConversionService conversionService;
    @Autowired
    protected GraphDatabaseService graphDatabaseService;
    @Autowired
    protected PersonRepository personRepository;
    @Autowired
    protected GroupRepository groupRepository;
    @Autowired
    protected FriendshipRepository friendshipRepository;
    protected TestTeam testTeam;

    @Before
    public void createTeam() throws Exception {
        this.testTeam = new TestTeam(this.neo4jTemplate);
    }

    protected Node getNodeState(Object entity) {
        return (Node)this.neo4jTemplate.getPersistentState(entity);
    }

    protected Long getNodeId(Object entity) {
        Node node = (Node)this.neo4jTemplate.getPersistentState(entity);
        return node == null ? null : Long.valueOf(node.getId());
    }

    protected Long getRelationshipId(Object entity) {
        Relationship rel = (Relationship)this.neo4jTemplate.getPersistentState(entity);
        return rel == null ? null : Long.valueOf(rel.getId());
    }

    protected boolean hasPersistentState(Object entity) {
        return this.neo4jTemplate.getPersistentState(entity) != null;
    }

    protected Relationship getRelationshipState(Object entity) {
        return (Relationship)this.neo4jTemplate.getPersistentState(entity);
    }

    public <T> T persist(T entity) {
        return (T)this.neo4jTemplate.save(entity);
    }

    protected <T> Set<T> set(T ... values) {
        return new HashSet<T>(Arrays.asList(values));
    }

    protected void manualCleanDb() {
        Transaction tx = this.graphDatabaseService.beginTx();
        try {
            this.cleanDb();
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    @BeforeTransaction
    public void cleanDb() {
        Neo4jHelper.cleanDb((Neo4jTemplate)this.neo4jTemplate);
    }

    protected StoredEntityType typeOf(Class<?> type) {
        return this.neo4jTemplate.getEntityType(type);
    }
}

