/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.aspects.support;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.neo4j.aspects.Friendship;
import org.springframework.data.neo4j.aspects.Group;
import org.springframework.data.neo4j.aspects.Mentorship;
import org.springframework.data.neo4j.aspects.Person;
import org.springframework.data.neo4j.aspects.support.EntityTestBase;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/springframework/data/neo4j/aspects/support/Neo4jGraphPersistenceTests-context.xml"})
public class NodeEntityRelationshipTests
extends EntityTestBase {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;

    @Test
    @Transactional
    public void testCreateRelationshipWithoutAnnotationOnSet() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_0);
                Person p = Person.persistedPerson("Michael", 35);
                Person spouse = Person.persistedPerson("Tina", 36);
                p.setSpouse(spouse);
                Node spouseNode = this.getNodeState(p).getSingleRelationship((RelationshipType)DynamicRelationshipType.withName((String)"spouse"), Direction.OUTGOING).getEndNode();
                Assert.assertEquals((Object)this.getNodeState(spouse), (Object)spouseNode);
                Assert.assertEquals((Object)spouse, (Object)p.getSpouse());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testCreateRelationshipWithAnnotationOnSet() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_1);
                Person p = Person.persistedPerson("Michael", 35);
                Person mother = Person.persistedPerson("Gabi", 60);
                p.setMother(mother);
                Node motherNode = this.getNodeState(p).getSingleRelationship((RelationshipType)DynamicRelationshipType.withName((String)"mother"), Direction.OUTGOING).getEndNode();
                Assert.assertEquals((Object)this.getNodeState(mother), (Object)motherNode);
                Assert.assertEquals((Object)mother, (Object)p.getMother());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testDeleteRelationship() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_2);
                Person p = Person.persistedPerson("Michael", 35);
                Person spouse = Person.persistedPerson("Tina", 36);
                p.setSpouse(spouse);
                p.setSpouse(null);
                Assert.assertNull((Object)this.getNodeState(p).getSingleRelationship((RelationshipType)DynamicRelationshipType.withName((String)"spouse"), Direction.OUTGOING));
                Assert.assertNull((Object)p.getSpouse());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testDeletePreviousRelationshipOnNewRelationship() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_3);
                Person p = Person.persistedPerson("Michael", 35);
                Person spouse = Person.persistedPerson("Tina", 36);
                Person friend = Person.persistedPerson("Helga", 34);
                p.setSpouse(spouse);
                p.setSpouse(friend);
                Assert.assertEquals((Object)this.getNodeState(friend), (Object)this.getNodeState(p).getSingleRelationship((RelationshipType)DynamicRelationshipType.withName((String)"spouse"), Direction.OUTGOING).getEndNode());
                Assert.assertEquals((Object)friend, (Object)p.getSpouse());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testCreateIncomingRelationshipWithAnnotationOnSet() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_4);
                Person p = Person.persistedPerson("David", 25);
                Person boss = Person.persistedPerson("Emil", 32);
                p.setBoss(boss);
                Assert.assertEquals((Object)this.getNodeState(boss), (Object)this.getNodeState(p).getSingleRelationship((RelationshipType)DynamicRelationshipType.withName((String)"boss"), Direction.INCOMING).getStartNode());
                Assert.assertEquals((Object)boss, (Object)p.getBoss());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Transactional
    public void testAllowsCircularRelationship() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_5);
                Person p = Person.persistedPerson("Michael", 35);
                p.setBoss(p);
                Assert.assertEquals((String)"created self-referencing relationship", (Object)p, (Object)p.getBoss());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testSetOneToManyRelationship() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_6);
                Person michael = Person.persistedPerson("Michael", 35);
                Person david = Person.persistedPerson("David", 25);
                Group group = this.persist(new Group());
                HashSet<Person> persons = new HashSet<Person>(Arrays.asList(michael, david));
                group.setPersons(persons);
                Relationship michaelRel = this.getNodeState(michael).getSingleRelationship((RelationshipType)DynamicRelationshipType.withName((String)"persons"), Direction.INCOMING);
                Relationship davidRel = this.getNodeState(david).getSingleRelationship((RelationshipType)DynamicRelationshipType.withName((String)"persons"), Direction.INCOMING);
                Assert.assertEquals((Object)this.getNodeState(group), (Object)michaelRel.getStartNode());
                Assert.assertEquals((Object)this.getNodeState(group), (Object)davidRel.getStartNode());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testGetOneToManyRelationship() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_7);
                Person michael = Person.persistedPerson("Michael", 35);
                Person david = Person.persistedPerson("David", 25);
                Group group = this.persist(new Group());
                HashSet<Person> persons = new HashSet<Person>(Arrays.asList(michael, david));
                group.setPersons(persons);
                Collection<Person> personsFromGet = group.getPersons();
                Assert.assertEquals(persons, personsFromGet);
                Assert.assertTrue((boolean)Set.class.isAssignableFrom(personsFromGet.getClass()));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testAddToOneToManyRelationship() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_8);
                Person michael = Person.persistedPerson("Michael", 35);
                Person david = Person.persistedPerson("David", 25);
                Group group = this.persist(new Group());
                group.setPersons(new HashSet<Person>());
                group.getPersons().add(michael);
                group.getPersons().add(david);
                Collection<Person> personsFromGet = group.getPersons();
                Assert.assertEquals(new HashSet<Person>(Arrays.asList(david, michael)), personsFromGet);
                Assert.assertTrue((boolean)Set.class.isAssignableFrom(personsFromGet.getClass()));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    public void testAddToOneToManyRelationshipOutsideOfTransaction() {
        Person michael = Person.persistedPerson("Michael", 35);
        Group group = this.persist(new Group());
        group.getPersons().add(michael);
        group = this.persist(group);
        Collection<Person> personsFromGet = group.getPersons();
        Assert.assertEquals(new HashSet<Person>(Arrays.asList(michael)), personsFromGet);
    }

    @Test
    @Transactional
    public void testRemoveFromOneToManyRelationship() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_9);
                Person michael = Person.persistedPerson("Michael", 35);
                Person david = Person.persistedPerson("David", 25);
                Group group = this.persist(new Group());
                group.setPersons(new HashSet<Person>(Arrays.asList(michael, david)));
                group.getPersons().remove(david);
                Assert.assertEquals(Collections.singleton(michael), group.getPersons());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testRemoveAllFromOneToManyRelationship() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_10);
                Person michael = Person.persistedPerson("Michael", 35);
                Person david = Person.persistedPerson("David", 25);
                Group group = this.persist(new Group());
                group.setPersons(new HashSet<Person>(Arrays.asList(michael, david)));
                group.getPersons().removeAll(Collections.singleton(david));
                Assert.assertEquals(Collections.singleton(michael), group.getPersons());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testRetainAllFromOneToManyRelationship() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_11);
                Person michael = Person.persistedPerson("Michael", 35);
                Person david = Person.persistedPerson("David", 25);
                Group group = this.persist(new Group());
                group.setPersons(new HashSet<Person>(Arrays.asList(michael, david)));
                group.getPersons().retainAll(Collections.singleton(david));
                Assert.assertEquals(Collections.singleton(david), group.getPersons());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testClearFromOneToManyRelationship() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_12);
                Person michael = Person.persistedPerson("Michael", 35);
                Person david = Person.persistedPerson("David", 25);
                Group group = this.persist(new Group());
                group.setPersons(new HashSet<Person>(Arrays.asList(michael, david)));
                group.getPersons().clear();
                Assert.assertEquals(Collections.emptySet(), group.getPersons());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testRelationshipGetEntities() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_13);
                Person p = Person.persistedPerson("Michael", 35);
                Person p2 = Person.persistedPerson("David", 25);
                Person p3 = Person.persistedPerson("Emil", 32);
                Friendship f2 = p.knows(p2);
                Friendship f3 = p.knows(p3);
                Assert.assertEquals(new HashSet<Friendship>(Arrays.asList(f2, f3)), (Object)IteratorUtil.addToCollection(p.getFriendships().iterator(), new HashSet()));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test(expected=InvalidDataAccessApiUsageException.class)
    @Transactional
    public void testRelationshipSetEntitiesShouldThrowException() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_14);
                Person p = Person.persistedPerson("Michael", 35);
                p.setFriendships(new HashSet<Friendship>());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testOneToManyReadOnly() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_15);
                Person michael = Person.persistedPerson("Michael", 35);
                Person david = Person.persistedPerson("David", 25);
                Group group = this.persist(new Group());
                HashSet<Person> persons = new HashSet<Person>(Arrays.asList(michael, david));
                group.setPersons(persons);
                Assert.assertEquals(persons, (Object)IteratorUtil.addToCollection(group.getReadOnlyPersons().iterator(), new HashSet()));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void multipleRelationshipsOfSameTypeBetweenTwoEntities() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_16);
                Person michael = Person.persistedPerson("Michael", 35);
                Person david = Person.persistedPerson("David", 25);
                Friendship friendship1 = (Friendship)this.neo4jTemplate.createRelationshipBetween((Object)michael, (Object)david, Friendship.class, "knows", true);
                friendship1.setYears(1);
                Friendship friendship2 = (Friendship)this.neo4jTemplate.createRelationshipBetween((Object)michael, (Object)david, Friendship.class, "knows", true);
                friendship2.setYears(2);
                Assert.assertTrue((String)"two different relationships", (friendship1 != friendship2 ? 1 : 0) != 0);
                Assert.assertTrue((String)"two different relationships", (this.getRelationshipState(friendship1) != this.getRelationshipState(friendship2) ? 1 : 0) != 0);
                Assert.assertEquals((long)1L, (long)friendship1.getYears());
                Assert.assertEquals((long)2L, (long)friendship2.getYears());
                Collection friends = IteratorUtil.asCollection((Iterable)this.getNodeState(michael).getRelationships(Direction.OUTGOING, new RelationshipType[]{DynamicRelationshipType.withName((String)"knows")}));
                Assert.assertEquals((long)2L, (long)friends.size());
                Assert.assertTrue((boolean)friends.contains(this.getRelationshipState(friendship1)));
                Assert.assertTrue((boolean)friends.contains(this.getRelationshipState(friendship2)));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test(expected=InvalidDataAccessApiUsageException.class)
    @Transactional
    public void testOneToManyReadOnlyShouldThrowExceptionOnSet() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_17);
                Group group = this.persist(new Group());
                group.setReadOnlyPersons(new HashSet<Person>());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testSingleRelatedToViaField() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_18);
                Group group = this.persist(new Group());
                Person mentor = this.persist(new Person());
                group.setMentorship(new Mentorship(mentor, group));
                this.persist(group);
                Node node = (Node)this.neo4jTemplate.getPersistentState((Object)group);
                Assert.assertEquals((long)1L, (long)IteratorUtil.count((Iterable)node.getRelationships(Direction.INCOMING, new RelationshipType[]{DynamicRelationshipType.withName((String)"mentors")})));
                Group loaded = (Group)this.neo4jTemplate.load((PropertyContainer)node, Group.class);
                Assert.assertEquals((Object)group.getMentorship(), (Object)loaded.getMentorship());
                Assert.assertEquals((Object)group.getMentorship().getId(), (Object)loaded.getMentorship().getId());
                Assert.assertEquals((Object)mentor, (Object)group.getMentorship().getMentor());
                Assert.assertEquals((Object)group, (Object)group.getMentorship().getGroup());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testRemoveSingleRelatedToViaField() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_19);
                Group group = this.persist(new Group());
                Person mentor = this.persist(new Person());
                group.setMentorship(new Mentorship(mentor, group));
                this.persist(group);
                group.setMentorship(null);
                this.persist(group);
                Node node = (Node)this.neo4jTemplate.getPersistentState((Object)group);
                Assert.assertEquals((long)0L, (long)IteratorUtil.count((Iterable)node.getRelationships(Direction.INCOMING, new RelationshipType[]{DynamicRelationshipType.withName((String)"mentors")})));
                Group loaded = (Group)this.neo4jTemplate.load((PropertyContainer)node, Group.class);
                Assert.assertThat((Object)loaded.getMentorship(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void testUpdateSingleRelatedToViaField() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_20);
                Group group = this.persist(new Group());
                group.setMentorship(new Mentorship(this.persist(new Person()), group));
                this.persist(group);
                Long firstMentorshipId = group.getMentorship().getId();
                Person mentor2 = new Person();
                group.setMentorship(new Mentorship(this.persist(mentor2), group));
                this.persist(group);
                Node node = (Node)this.neo4jTemplate.getPersistentState((Object)group);
                Assert.assertEquals((long)1L, (long)IteratorUtil.count((Iterable)node.getRelationships(Direction.INCOMING, new RelationshipType[]{DynamicRelationshipType.withName((String)"mentors")})));
                Group loaded = (Group)this.neo4jTemplate.load((PropertyContainer)node, Group.class);
                Assert.assertFalse((boolean)loaded.getMentorship().getId().equals(firstMentorshipId));
                Assert.assertEquals((Object)mentor2, (Object)group.getMentorship().getMentor());
                Assert.assertEquals((Object)group, (Object)group.getMentorship().getGroup());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    static {
        NodeEntityRelationshipTests.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("NodeEntityRelationshipTests.java", NodeEntityRelationshipTests.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testCreateRelationshipWithoutAnnotationOnSet", "org.springframework.data.neo4j.aspects.support.NodeEntityRelationshipTests", "", "", "", "void"), 57);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testCreateRelationshipWithAnnotationOnSet", "org.springframework.data.neo4j.aspects.support.NodeEntityRelationshipTests", "", "", "", "void"), 68);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testRemoveAllFromOneToManyRelationship", "org.springframework.data.neo4j.aspects.support.NodeEntityRelationshipTests", "", "", "", "void"), 180);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testRetainAllFromOneToManyRelationship", "org.springframework.data.neo4j.aspects.support.NodeEntityRelationshipTests", "", "", "", "void"), 190);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testClearFromOneToManyRelationship", "org.springframework.data.neo4j.aspects.support.NodeEntityRelationshipTests", "", "", "", "void"), 200);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testRelationshipGetEntities", "org.springframework.data.neo4j.aspects.support.NodeEntityRelationshipTests", "", "", "", "void"), 212);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testRelationshipSetEntitiesShouldThrowException", "org.springframework.data.neo4j.aspects.support.NodeEntityRelationshipTests", "", "", "", "void"), 223);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testOneToManyReadOnly", "org.springframework.data.neo4j.aspects.support.NodeEntityRelationshipTests", "", "", "", "void"), 230);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "multipleRelationshipsOfSameTypeBetweenTwoEntities", "org.springframework.data.neo4j.aspects.support.NodeEntityRelationshipTests", "", "", "", "void"), 241);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testOneToManyReadOnlyShouldThrowExceptionOnSet", "org.springframework.data.neo4j.aspects.support.NodeEntityRelationshipTests", "", "", "", "void"), 261);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testSingleRelatedToViaField", "org.springframework.data.neo4j.aspects.support.NodeEntityRelationshipTests", "", "", "", "void"), 268);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testRemoveSingleRelatedToViaField", "org.springframework.data.neo4j.aspects.support.NodeEntityRelationshipTests", "", "", "", "void"), 284);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testDeleteRelationship", "org.springframework.data.neo4j.aspects.support.NodeEntityRelationshipTests", "", "", "", "void"), 79);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testUpdateSingleRelatedToViaField", "org.springframework.data.neo4j.aspects.support.NodeEntityRelationshipTests", "", "", "", "void"), 298);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testDeletePreviousRelationshipOnNewRelationship", "org.springframework.data.neo4j.aspects.support.NodeEntityRelationshipTests", "", "", "", "void"), 90);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testCreateIncomingRelationshipWithAnnotationOnSet", "org.springframework.data.neo4j.aspects.support.NodeEntityRelationshipTests", "", "", "", "void"), 102);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testAllowsCircularRelationship", "org.springframework.data.neo4j.aspects.support.NodeEntityRelationshipTests", "", "", "", "void"), 111);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testSetOneToManyRelationship", "org.springframework.data.neo4j.aspects.support.NodeEntityRelationshipTests", "", "", "", "void"), 119);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testGetOneToManyRelationship", "org.springframework.data.neo4j.aspects.support.NodeEntityRelationshipTests", "", "", "", "void"), 133);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testAddToOneToManyRelationship", "org.springframework.data.neo4j.aspects.support.NodeEntityRelationshipTests", "", "", "", "void"), 146);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testRemoveFromOneToManyRelationship", "org.springframework.data.neo4j.aspects.support.NodeEntityRelationshipTests", "", "", "", "void"), 170);
    }
}

