/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.aspects;

import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.annotation.QueryType;
import org.springframework.data.neo4j.aspects.Group;
import org.springframework.data.neo4j.aspects.Person;
import org.springframework.data.neo4j.repository.GraphRepository;
import org.springframework.data.neo4j.repository.NamedIndexRepository;
import org.springframework.data.repository.query.Param;

public interface PersonRepository
extends GraphRepository<Person>,
NamedIndexRepository<Person> {
    @Query(value="start team=node({p_team}) match (team)-[:persons]->(member) return member")
    public Iterable<Person> findAllTeamMembers(@Param(value="p_team") Group var1);

    @Query(value="g.v(team).out('persons')", type=QueryType.Gremlin)
    public Iterable<Person> findAllTeamMembersGremlin(@Param(value="team") Group var1);

    @Query(value="start team=node({p_team}) match (team)-[:persons]->(member) return member.name,member.age")
    public Iterable<Map<String, Object>> findAllTeamMemberData(@Param(value="p_team") Group var1);

    @Query(value="start person=node({p_person}) match (person)<-[:boss]-(boss) return boss")
    public Person findBoss(@Param(value="p_person") Person var1);

    public Group findTeam(@Param(value="p_person") Person var1);

    @Query(value="start team=node({p_team}) match (team)-[:persons]->(member) return member")
    public Page<Person> findAllTeamMembersPaged(@Param(value="p_team") Group var1, Pageable var2);

    @Query(value="start team=node({p_team}) match (team)-[:persons]->(member) return member")
    public Iterable<Person> findAllTeamMembersSorted(@Param(value="p_team") Group var1, Sort var2);
}

