/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.partial;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.sql.DataSource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.aspects.core.NodeBacked;
import org.springframework.data.neo4j.aspects.support.node.Neo4jNodeBacking;
import org.springframework.data.neo4j.partial.User;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.node.Neo4jHelper;
import org.springframework.orm.jpa.aspectj.JpaExceptionTranslatorAspect;
import org.springframework.test.context.CleanContextCacheTestExecutionListener;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/springframework/data/neo4j/partial/Neo4jGraphRecommendationTest-context.xml"})
@TestExecutionListeners(value={CleanContextCacheTestExecutionListener.class, DependencyInjectionTestExecutionListener.class, TransactionalTestExecutionListener.class})
public class RecommendationTest {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    PlatformTransactionManager transactionManager;
    @Autowired
    private Neo4jTemplate template;
    @PersistenceContext
    EntityManager em;
    @Autowired
    DataSource dataSource;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    @BeforeTransaction
    public void cleanDb() {
        Neo4jHelper.cleanDb((Neo4jTemplate)this.template);
    }

    @Test
    @Transactional
    public void jpaUserHasNodeAndId() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_0);
                User user = this.user("John");
                Assert.assertNotNull((String)"jpa-id", (Object)user.getId());
                Assert.assertNotNull((String)"node", (Object)Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getPersistentState((NodeBacked)user));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    @Test
    @Transactional
    public void jpaUserCanHaveGraphProperties() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_1);
                User user = this.user("John");
                Assert.assertNotNull((String)"jpa-id", (Object)user.getId());
                Assert.assertNotNull((String)"node", (Object)Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getPersistentState((NodeBacked)user));
                Assert.assertNotNull((String)"nickname in entity", (Object)user.getNickname());
                Assert.assertEquals((String)"nickname in graph", (Object)"John", (Object)Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getPersistentState((NodeBacked)user).getProperty("nickname"));
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    private User user(String name) {
        User user = new User();
        user.setAge(35);
        user.setNickname(name);
        try {
            this.em.persist((Object)user);
        }
        catch (RuntimeException runtimeException) {
            JpaExceptionTranslatorAspect.aspectOf().ajc$afterThrowing$org_springframework_orm_jpa_aspectj_JpaExceptionTranslatorAspect$1$18a1ac9(runtimeException);
            throw runtimeException;
        }
        try {
            this.em.flush();
        }
        catch (RuntimeException runtimeException) {
            JpaExceptionTranslatorAspect.aspectOf().ajc$afterThrowing$org_springframework_orm_jpa_aspectj_JpaExceptionTranslatorAspect$1$18a1ac9(runtimeException);
            throw runtimeException;
        }
        return (User)Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$persist((NodeBacked)user);
    }

    @Test
    @Transactional
    public void jpaUserCanHaveGraphRelationships() {
        try {
            try {
                AnnotationTransactionAspect.aspectOf().ajc$before$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, ajc$tjp_2);
                User user = this.user("John");
                Assert.assertNotNull((String)"jpa-id", (Object)user.getId());
                Assert.assertNotNull((String)"node", (Object)Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getPersistentState((NodeBacked)user));
                User user2 = this.user("Jane");
                user.getFriends().add(user2);
                Assert.assertEquals((Object)user2, (Object)user.getFriends().iterator().next());
            }
            catch (Throwable throwable) {
                AnnotationTransactionAspect.aspectOf().ajc$afterThrowing$org_springframework_transaction_aspectj_AbstractTransactionAspect$2$2a73e96c((Object)this, throwable);
                throw throwable;
            }
            AnnotationTransactionAspect.aspectOf().ajc$afterReturning$org_springframework_transaction_aspectj_AbstractTransactionAspect$3$2a73e96c((Object)this);
        }
        finally {
            AnnotationTransactionAspect.aspectOf().ajc$after$org_springframework_transaction_aspectj_AbstractTransactionAspect$4$2a73e96c((Object)this);
        }
    }

    static {
        RecommendationTest.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RecommendationTest.java", RecommendationTest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "jpaUserHasNodeAndId", "org.springframework.data.neo4j.partial.RecommendationTest", "", "", "", "void"), 68);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "jpaUserCanHaveGraphProperties", "org.springframework.data.neo4j.partial.RecommendationTest", "", "", "", "void"), 75);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "jpaUserCanHaveGraphRelationships", "org.springframework.data.neo4j.partial.RecommendationTest", "", "", "", "void"), 94);
    }
}

