/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.cross_store.config;

import javax.persistence.EntityManagerFactory;
import org.neo4j.graphdb.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.aspects.config.Neo4jAspectConfiguration;
import org.springframework.data.neo4j.config.JtaTransactionManagerFactoryBean;
import org.springframework.data.neo4j.cross_store.support.node.CrossStoreNodeDelegatingFieldAccessorFactory;
import org.springframework.data.neo4j.cross_store.support.node.CrossStoreNodeEntityInstantiator;
import org.springframework.data.neo4j.cross_store.support.node.CrossStoreNodeEntityStateFactory;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactoryFactory;
import org.springframework.data.neo4j.mapping.EntityInstantiator;
import org.springframework.data.neo4j.support.node.NodeEntityInstantiator;
import org.springframework.data.neo4j.support.node.NodeEntityStateFactory;
import org.springframework.data.neo4j.transaction.ChainedTransactionManager;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;

@Configuration
public class CrossStoreNeo4jConfiguration
extends Neo4jAspectConfiguration {
    private EntityManagerFactory entityManagerFactory;

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    @Qualifier(value="&entityManagerFactory")
    @Autowired(required=false)
    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public boolean isUsingCrossStorePersistence() {
        return this.entityManagerFactory != null;
    }

    @Bean
    protected EntityInstantiator<Node> graphEntityInstantiator() throws Exception {
        if (this.isUsingCrossStorePersistence()) {
            return new CrossStoreNodeEntityInstantiator(new NodeEntityInstantiator(this.entityStateHandler()), this.entityManagerFactory);
        }
        return new NodeEntityInstantiator(this.entityStateHandler());
    }

    @Bean
    public PlatformTransactionManager neo4jTransactionManager() throws Exception {
        JtaTransactionManager jtaTm = new JtaTransactionManagerFactoryBean(this.getGraphDatabaseService()).getObject();
        if (this.isUsingCrossStorePersistence()) {
            JpaTransactionManager jpaTm = new JpaTransactionManager(this.getEntityManagerFactory());
            return new ChainedTransactionManager(new PlatformTransactionManager[]{jpaTm, jtaTm});
        }
        return jtaTm;
    }

    public FieldAccessorFactoryFactory nodeDelegatingFieldAccessorFactory() throws Exception {
        return new CrossStoreNodeDelegatingFieldAccessorFactory.Factory();
    }

    @Bean
    public NodeEntityStateFactory nodeEntityStateFactory() throws Exception {
        return new CrossStoreNodeEntityStateFactory(this.neo4jMappingContext(), this.nodeDelegatingFieldAccessorFactory(), this.entityManagerFactory);
    }
}

