/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.cross_store.support.node;

import java.util.Arrays;
import java.util.Collection;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.aspectj.AbstractDependencyInjectionAspect;
import org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect;
import org.springframework.beans.factory.aspectj.ConfigurableObject;
import org.springframework.data.neo4j.annotation.GraphProperty;
import org.springframework.data.neo4j.annotation.RelatedTo;
import org.springframework.data.neo4j.cross_store.fieldaccess.JpaIdFieldAccessListenerFactory;
import org.springframework.data.neo4j.fieldaccess.ConvertingNodePropertyFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.DelegatingFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactoryFactory;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorListenerFactory;
import org.springframework.data.neo4j.fieldaccess.IndexingPropertyFieldAccessorListenerFactory;
import org.springframework.data.neo4j.fieldaccess.PropertyFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.QueryFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.ReadOnlyRelatedToCollectionFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.RelatedToCollectionFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.RelatedToSingleFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.RelatedToViaCollectionFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.RelatedToViaSingleFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.TraversalFieldAccessorFactory;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public class CrossStoreNodeDelegatingFieldAccessorFactory
extends DelegatingFieldAccessorFactory {
    public CrossStoreNodeDelegatingFieldAccessorFactory(Neo4jTemplate template) {
        super(template);
    }

    protected Collection<FieldAccessorListenerFactory> createListenerFactories() {
        return Arrays.asList(new IndexingPropertyFieldAccessorListenerFactory(this.getTemplate(), this.newPropertyFieldAccessorFactory(), this.newConvertingNodePropertyFieldAccessorFactory()){

            public boolean accept(Neo4jPersistentProperty property) {
                return property.isAnnotationPresent(GraphProperty.class) && super.accept(property);
            }
        }, new JpaIdFieldAccessListenerFactory(this.template));
    }

    protected Collection<? extends FieldAccessorFactory> createAccessorFactories() {
        return Arrays.asList(new TraversalFieldAccessorFactory(this.template), new QueryFieldAccessorFactory(this.template), this.newPropertyFieldAccessorFactory(), this.newConvertingNodePropertyFieldAccessorFactory(), new RelatedToSingleFieldAccessorFactory(this.getTemplate()){

            public boolean accept(Neo4jPersistentProperty property) {
                return property.isAnnotationPresent(RelatedTo.class) && super.accept(property);
            }
        }, new RelatedToCollectionFieldAccessorFactory(this.getTemplate()), new ReadOnlyRelatedToCollectionFieldAccessorFactory(this.getTemplate()), new RelatedToViaSingleFieldAccessorFactory(this.getTemplate()), new RelatedToViaCollectionFieldAccessorFactory(this.getTemplate()));
    }

    private ConvertingNodePropertyFieldAccessorFactory newConvertingNodePropertyFieldAccessorFactory() {
        return new ConfigurableObject(this.getTemplate()){
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
            {
                CrossStoreNodeDelegatingFieldAccessorFactory crossStoreNodeDelegatingFieldAccessorFactory2 = CrossStoreNodeDelegatingFieldAccessorFactory.this;
                Neo4jTemplate neo4jTemplate = $anonymous0;
                JoinPoint joinPoint = org.aspectj.runtime.reflect.Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)((Object)crossStoreNodeDelegatingFieldAccessorFactory2), (Object)neo4jTemplate);
                JoinPoint joinPoint2 = org.aspectj.runtime.reflect.Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
                if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(Configurable.class) && AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)((Object)((Object)this)).getClass().getAnnotation(Configurable.class))) {
                    AnnotationBeanConfigurerAspect.aspectOf().ajc$before$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$1$e854fa65((Object)this);
                }
                if (this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(Configurable.class) && (this == null || !((Object)((Object)this)).getClass().isAnnotationPresent(Configurable.class) || !AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)((Object)((Object)this)).getClass().getAnnotation(Configurable.class))) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint2)) {
                    AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
                }
                if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)((Object)((Object)this)).getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
                    AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
                }
            }

            public boolean accept(Neo4jPersistentProperty property) {
                return property.isAnnotationPresent(GraphProperty.class) && super.accept(property);
            }

            static {
                3.ajc$preClinit();
            }

            private static /* synthetic */ void ajc$preClinit() {
                org.aspectj.runtime.reflect.Factory factory = new org.aspectj.runtime.reflect.Factory("CrossStoreNodeDelegatingFieldAccessorFactory.java", 3.class);
                ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.springframework.beans.factory.aspectj.ConfigurableObject", "", "", ""), 89);
                ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("0", "org.springframework.data.neo4j.cross_store.support.node.CrossStoreNodeDelegatingFieldAccessorFactory$3", "org.springframework.data.neo4j.cross_store.support.node.CrossStoreNodeDelegatingFieldAccessorFactory:org.springframework.data.neo4j.support.Neo4jTemplate", "arg0:$anonymous0", ""), 89);
            }
        };
    }

    private PropertyFieldAccessorFactory newPropertyFieldAccessorFactory() {
        return new PropertyFieldAccessorFactory(this.getTemplate()){

            public boolean accept(Neo4jPersistentProperty property) {
                return property.isAnnotationPresent(GraphProperty.class) && super.accept(property);
            }
        };
    }

    public static class Factory
    extends FieldAccessorFactoryFactory {
        public DelegatingFieldAccessorFactory create(Neo4jTemplate template) {
            return new CrossStoreNodeDelegatingFieldAccessorFactory(template);
        }
    }
}

