/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.cross_store.support.node;

import javax.persistence.PersistenceUnitUtil;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.neo4j.aspects.core.NodeBacked;
import org.springframework.data.neo4j.aspects.support.node.Neo4jNodeBacking;
import org.springframework.data.neo4j.fieldaccess.DefaultEntityState;
import org.springframework.data.neo4j.fieldaccess.DelegatingFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.index.IndexType;

public class CrossStoreNodeEntityState<ENTITY extends NodeBacked>
extends DefaultEntityState<Node> {
    public static final String FOREIGN_ID = "foreignId";
    public static final String FOREIGN_ID_INDEX = "foreign_id";
    private final Neo4jTemplate template;
    private PersistenceUnitUtil persistenceUnitUtil;

    public CrossStoreNodeEntityState(Node underlyingState, NodeBacked entity, Class<? extends NodeBacked> type, Neo4jTemplate template, PersistenceUnitUtil persistenceUnitUtil, DelegatingFieldAccessorFactory delegatingFieldAccessorFactory, Neo4jPersistentEntity persistentEntity) {
        super((Object)underlyingState, (Object)entity, type, delegatingFieldAccessorFactory, persistentEntity);
        this.template = template;
        this.persistenceUnitUtil = persistenceUnitUtil;
    }

    public void createAndAssignState() {
        NodeBacked entity = (NodeBacked)this.entity;
        if (Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getPersistentState((NodeBacked)entity) != null) {
            return;
        }
        try {
            Object id = this.getId(entity);
            if (id == null) {
                return;
            }
            String foreignId = this.createForeignId(id);
            IndexHits indexHits = this.getForeignIdIndex().get(FOREIGN_ID, (Object)foreignId);
            Node node = indexHits.hasNext() ? (Node)indexHits.next() : null;
            indexHits.close();
            if (node == null) {
                node = this.persistentEntity.isUnique() ? this.template.createUniqueNode((Object)entity) : this.template.createNode();
                this.persistForeignId(node, id);
                this.setPersistentState(node);
                if (DefaultEntityState.log.isDebugEnabled()) {
                    DefaultEntityState.log.debug("User-defined constructor called on class " + entity.getClass() + "; created Node [" + Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$getPersistentState((NodeBacked)entity) + "]; Updating metamodel");
                }
                this.template.postEntityCreation((PropertyContainer)node, this.type);
            } else {
                this.setPersistentState(node);
                Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_aspects_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_aspects_core_NodeBacked$setPersistentState((NodeBacked)entity, (Node)node);
            }
        }
        catch (NotInTransactionException e) {
            throw new InvalidDataAccessResourceUsageException("Not in a Neo4j transaction.", (Throwable)e);
        }
    }

    public ENTITY persist() {
        if (this.getPersistentState() == null) {
            this.createAndAssignState();
        }
        return (ENTITY)((NodeBacked)this.entity);
    }

    public boolean isWritable(Neo4jPersistentProperty property) {
        FieldAccessor accessor = this.accessorFor(property);
        if (accessor == null) {
            return false;
        }
        return accessor.isWriteable(this.entity);
    }

    private void persistForeignId(Node node, Object id) {
        if (!node.hasProperty(FOREIGN_ID) && id != null) {
            String foreignId = this.createForeignId(id);
            node.setProperty(FOREIGN_ID, id);
            this.getForeignIdIndex().add((PropertyContainer)node, FOREIGN_ID, (Object)foreignId);
        }
    }

    private Index<Node> getForeignIdIndex() {
        return this.template.getIndex(this.type, null, IndexType.SIMPLE);
    }

    private String createForeignId(Object id) {
        return String.valueOf(this.type.getName()) + ":" + id;
    }

    public Object getId(Object entity) {
        return this.persistenceUnitUtil != null ? this.persistenceUnitUtil.getIdentifier(entity) : null;
    }
}

