/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest;

import java.util.Iterator;
import org.neo4j.rest.graphdb.util.ConvertedResult;
import org.neo4j.rest.graphdb.util.QueryResult;
import org.neo4j.rest.graphdb.util.ResultConverter;
import org.springframework.data.neo4j.conversion.ContainerConverter;
import org.springframework.data.neo4j.conversion.EndResult;
import org.springframework.data.neo4j.conversion.Handler;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.rest.SpringEndResult;
import org.springframework.data.neo4j.rest.SpringHandler;

class SpringRestResult<T>
implements Result<T> {
    QueryResult<T> queryResult;
    private MappingPolicy mappingPolicy;

    SpringRestResult(QueryResult<T> queryResult) {
        this.queryResult = queryResult;
    }

    public <R> EndResult<R> to(Class<R> type) {
        return new SpringEndResult(this.queryResult.to(type));
    }

    public <R> EndResult<R> to(Class<R> type, final org.springframework.data.neo4j.conversion.ResultConverter<T, R> converter) {
        ConvertedResult result = this.queryResult.to(type, new ResultConverter<T, R>(){

            public R convert(T value, Class<R> type) {
                return converter.convert(value, type, SpringRestResult.this.mappingPolicy);
            }
        });
        return new SpringEndResult(result);
    }

    public void handle(Handler<T> handler) {
        this.queryResult.handle(new SpringHandler<T>(handler));
    }

    public Iterator<T> iterator() {
        return this.queryResult.iterator();
    }

    public T singleOrNull() {
        return (T)this.to(Object.class).singleOrNull();
    }

    public T single() {
        return (T)this.to(Object.class).single();
    }

    public Result<T> with(MappingPolicy mappingPolicy) {
        this.mappingPolicy = mappingPolicy;
        return this;
    }

    public <C extends Iterable<T>> C as(Class<C> container) {
        return (C)ContainerConverter.toContainer(container, (Iterable)((Object)this));
    }

    public void finish() {
    }
}

