/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest.support;

import org.hamcrest.Description;
import org.junit.internal.matchers.TypeSafeMatcher;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

class IsRelationshipToNodeMatcher
extends TypeSafeMatcher<Iterable<Relationship>> {
    private final Node startNode;
    private final Node endNode;

    public IsRelationshipToNodeMatcher(Node startNode, Node endNode) {
        this.startNode = startNode;
        this.endNode = endNode;
    }

    public boolean matchesSafely(Iterable<Relationship> relationships) {
        return IsRelationshipToNodeMatcher.relationshipFromTo(relationships, this.startNode, this.endNode) != null;
    }

    public static Relationship relationshipFromTo(Iterable<Relationship> relationships, Node startNode, Node endNode) {
        for (Relationship relationship : relationships) {
            if (!relationship.getOtherNode(startNode).equals(endNode)) continue;
            return relationship;
        }
        return null;
    }

    public void describeTo(Description description) {
        description.appendValue((Object)this.startNode).appendText(" to ").appendValue((Object)this.endNode).appendText("not contained in relationships");
    }
}

