/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest.support;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.IndexManager;

public class Neo4jDatabaseCleaner {
    private GraphDatabaseService graph;

    public Neo4jDatabaseCleaner(GraphDatabaseService graph) {
        this.graph = graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> cleanDb() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Transaction tx = this.graph.beginTx();
        try {
            this.removeNodes(result);
            this.clearIndex(result);
            tx.success();
        }
        finally {
            tx.finish();
        }
        return result;
    }

    private void removeNodes(Map<String, Object> result) {
        Node refNode = this.graph.getReferenceNode();
        int nodes = 0;
        int relationships = 0;
        for (Node node : this.graph.getAllNodes()) {
            for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                rel.delete();
                ++relationships;
            }
            if (refNode.equals(node)) continue;
            node.delete();
            ++nodes;
        }
        result.put("nodes", nodes);
        result.put("relationships", relationships);
    }

    private void clearIndex(Map<String, Object> result) {
        IndexManager indexManager = this.graph.index();
        result.put("node-indexes", Arrays.asList(indexManager.nodeIndexNames()));
        result.put("relationship-indexes", Arrays.asList(indexManager.relationshipIndexNames()));
        for (String ix : indexManager.nodeIndexNames()) {
            indexManager.forNodes(ix).delete();
        }
        for (String ix : indexManager.relationshipIndexNames()) {
            indexManager.forRelationships(ix).delete();
        }
    }
}

