/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest.support;

import java.util.Date;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.data.neo4j.rest.support.IsRelationshipToNodeMatcher;
import org.springframework.data.neo4j.rest.support.RestTestBase;
import org.springframework.data.neo4j.rest.support.Type;

public class RestGraphDbTests
extends RestTestBase {
    @Test
    public void testGetRefNode() {
        Node refNode = this.restGraphDatabase.getReferenceNode();
        Node nodeById = this.restGraphDatabase.getNodeById(0L);
        Assert.assertEquals((Object)refNode, (Object)nodeById);
    }

    @Test
    public void testCreateNode() {
        Node node = this.restGraphDatabase.createNode();
        Assert.assertEquals((Object)node, (Object)this.restGraphDatabase.getNodeById(node.getId()));
    }

    @Test
    public void testCreateRelationship() {
        Node refNode = this.restGraphDatabase.getReferenceNode();
        Node node = this.restGraphDatabase.createNode();
        Relationship rel = refNode.createRelationshipTo(node, (RelationshipType)Type.TEST);
        Relationship foundRelationship = IsRelationshipToNodeMatcher.relationshipFromTo(refNode.getRelationships((RelationshipType)Type.TEST, Direction.OUTGOING), refNode, node);
        Assert.assertNotNull((String)"found relationship", (Object)foundRelationship);
        Assert.assertEquals((String)"same relationship", (Object)rel, (Object)foundRelationship);
        Assert.assertThat((Object)refNode.getRelationships((RelationshipType)Type.TEST, Direction.OUTGOING), (Matcher)new IsRelationshipToNodeMatcher(refNode, node));
        Assert.assertThat((Object)refNode.getRelationships(Direction.OUTGOING), (Matcher)new IsRelationshipToNodeMatcher(refNode, node));
        Assert.assertThat((Object)refNode.getRelationships(Direction.BOTH), (Matcher)new IsRelationshipToNodeMatcher(refNode, node));
        Assert.assertThat((Object)refNode.getRelationships(new RelationshipType[]{Type.TEST}), (Matcher)new IsRelationshipToNodeMatcher(refNode, node));
    }

    @Test
    public void testBasic() {
        Node refNode = this.restGraphDatabase.getReferenceNode();
        Node node = this.restGraphDatabase.createNode();
        Relationship rel = refNode.createRelationshipTo(node, (RelationshipType)DynamicRelationshipType.withName((String)"TEST"));
        rel.setProperty("date", (Object)new Date().getTime());
        node.setProperty("name", (Object)"Mattias test");
        refNode.createRelationshipTo(node, (RelationshipType)DynamicRelationshipType.withName((String)"TEST"));
        for (Relationship relationship : refNode.getRelationships()) {
            System.out.println("rel prop:" + relationship.getProperty("date", null));
            Node endNode = relationship.getEndNode();
            System.out.println("node prop:" + endNode.getProperty("name", null));
        }
    }
}

