/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest.support;

import java.net.URISyntaxException;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.server.NeoServer;
import org.neo4j.server.WrappingNeoServerBootstrapper;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.ServerConfigurator;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.rest.SpringRestGraphDatabase;

public class RestTestHelper {
    private static final String HOSTNAME = "localhost";
    private static final int PORT = 7470;
    private static NeoServer neoServer;
    private static final String SERVER_ROOT_URI = "http://localhost:7470/db/data/";
    private static ImpermanentGraphDatabase db;

    public void startServer() throws Exception {
        db = new ImpermanentGraphDatabase();
        ServerConfigurator configurator = new ServerConfigurator((GraphDatabaseAPI)db);
        configurator.configuration().setProperty("org.neo4j.server.webserver.port", (Object)7470);
        WrappingNeoServerBootstrapper bootstrapper = new WrappingNeoServerBootstrapper((GraphDatabaseAPI)db, (Configurator)configurator);
        bootstrapper.start();
        neoServer = bootstrapper.getServer();
    }

    public GraphDatabase createGraphDatabase() throws URISyntaxException {
        return new SpringRestGraphDatabase(SERVER_ROOT_URI);
    }

    public void cleanDb() {
        db.cleanContent(true);
    }

    public static void shutdownServer() {
        neoServer.stop();
        neoServer = null;
    }
}

