/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest.support;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.rest.graphdb.RequestResult;
import org.springframework.data.neo4j.aspects.Person;
import org.springframework.data.neo4j.rest.support.RestTestBase;
import org.springframework.data.neo4j.server.ProvidedClassPathXmlApplicationContext;

public class ServerPluginTests
extends RestTestBase {
    @BeforeClass
    public static void init() {
        new ProvidedClassPathXmlApplicationContext((GraphDatabaseService)db, new String[]{"Plugin-context.xml"});
    }

    @Test
    public void testGetFriends() throws IOException {
        Person person = Person.persistedPerson((String)"Michael", (int)35);
        RequestResult requestResult = RequestResult.extractFrom((ClientResponse)((ClientResponse)ServerPluginTests.createRequest("ext/TestServerPlugin/graphdb/person").post(ClientResponse.class, (Object)("{\"name\":\"" + person.getName() + "\"}"))));
        Assert.assertEquals((long)200L, (long)requestResult.getStatus());
        String result = requestResult.getText();
        Map data = (Map)new ObjectMapper().readValue(result, Object.class);
        Assert.assertEquals((Object)person.getName(), ((Map)data.get("data")).get("name"));
    }

    private ClientResponse post(String uriSuffix, String params) {
        return (ClientResponse)ServerPluginTests.createRequest(uriSuffix).post(ClientResponse.class, (Object)params);
    }

    private static WebResource.Builder createRequest(String uriSuffix) {
        return (WebResource.Builder)Client.create().resource("http://127.0.0.1:7470/db/data/" + uriSuffix).type("application/json").accept(new String[]{"application/json"});
    }
}

