/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest.support;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.commons.configuration.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.rest.graphdb.RequestResult;
import org.neo4j.server.NeoServer;
import org.neo4j.server.WrappingNeoServerBootstrapper;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.ServerConfigurator;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.springframework.data.neo4j.rest.support.TestInterface;
import org.springframework.data.neo4j.server.SpringPluginInitializer;

@Path(value="/")
public class SpringPluginInitializerTests
extends SpringPluginInitializer
implements TestInterface {
    private NeoServer neoServer;
    private static int touched = 0;
    private static final String HOSTNAME = "localhost";
    private static final int PORT = 7470;

    public SpringPluginInitializerTests() {
        super(new String[]{"ServerTests-context.xml"}, new Pair[]{SpringPluginInitializerTests.expose((String)"testObject", TestInterface.class)});
    }

    @Path(value="/testInterface")
    @POST
    @Produces(value={"application/json"})
    public void runThis(@Context TestInterface test) {
        test.thisIsARecording();
    }

    @Path(value="/testNoContext")
    @POST
    @Produces(value={"application/json"})
    public void runThis() {
    }

    @Before
    public void setUp() throws Exception {
        ImpermanentGraphDatabase db = new ImpermanentGraphDatabase();
        ServerConfigurator configurator = new ServerConfigurator((GraphDatabaseAPI)db){

            public Set<ThirdPartyJaxRsPackage> getThirdpartyJaxRsClasses() {
                return Collections.singleton(new ThirdPartyJaxRsPackage("org.springframework.data.neo4j.rest.support", "/test"));
            }

            public Set<ThirdPartyJaxRsPackage> getThirdpartyJaxRsPackages() {
                return Collections.singleton(new ThirdPartyJaxRsPackage("org.springframework.data.neo4j.rest.support", "/test"));
            }
        };
        Configuration configuration = configurator.configuration();
        configuration.setProperty("org.neo4j.server.webserver.port", (Object)7470);
        WrappingNeoServerBootstrapper bootstrapper = new WrappingNeoServerBootstrapper((GraphDatabaseAPI)db, (Configurator)configurator);
        touched = 0;
        bootstrapper.start();
        this.neoServer = bootstrapper.getServer();
    }

    @After
    public void tearDown() throws Exception {
        this.neoServer.stop();
    }

    @Test
    public void shouldInjectInterface() throws Exception {
        RequestResult requestResult = this.sendRequest("testInterface");
        Assert.assertEquals((long)204L, (long)requestResult.getStatus());
        Assert.assertEquals((long)1L, (long)touched);
    }

    @Test
    public void shouldWorkWithThirdPartyJaxrs() throws Exception {
        RequestResult requestResult = this.sendRequest("testNoContext");
        Assert.assertEquals((long)204L, (long)requestResult.getStatus());
    }

    private RequestResult sendRequest(String method) {
        return RequestResult.extractFrom((ClientResponse)((ClientResponse)((WebResource.Builder)Client.create().resource("http://localhost:7470/test/" + method).type("application/json").accept(new String[]{"application/json"})).post(ClientResponse.class)));
    }

    @Override
    public void thisIsARecording() {
        ++touched;
    }
}

