/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.converter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.rest.graphdb.RestAPI;
import org.neo4j.rest.graphdb.RestResultException;
import org.neo4j.rest.graphdb.converter.ConversionInfo;
import org.neo4j.rest.graphdb.converter.RestEntityExtractor;
import org.neo4j.rest.graphdb.converter.RestTableResultExtractor;
import org.neo4j.rest.graphdb.converter.TypeInformation;
import org.neo4j.rest.graphdb.traversal.RestPathParser;

public class ResultTypeConverter {
    private RestAPI restAPI;
    private RestEntityExtractor restEntityExtractor;

    public ResultTypeConverter(RestAPI restAPI) {
        this.restAPI = restAPI;
        this.restEntityExtractor = new RestEntityExtractor(this.restAPI);
    }

    public Object convertToResultType(Object resultObject, TypeInformation typeInformation) {
        if (typeInformation.isSingleType() || typeInformation.isPath(typeInformation.type)) {
            return this.convertSingleTypeToResultType(resultObject, typeInformation, typeInformation.type);
        }
        if (typeInformation.isCollection()) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object innerObject : this.toIterable(resultObject)) {
                result.add(this.convertSingleTypeToResultType(innerObject, typeInformation, typeInformation.genericArguments[0]));
            }
            return result;
        }
        if (typeInformation.isMap()) {
            Map<?, ?> originalMap = this.toMap(resultObject);
            HashMap<Object, Object> result = new HashMap<Object, Object>(((Map)resultObject).size());
            for (Map.Entry<?, ?> entry : originalMap.entrySet()) {
                Object resultKey = this.convertSingleTypeToResultType(entry.getKey(), typeInformation, typeInformation.genericArguments[0]);
                Object resultValue = this.convertSingleTypeToResultType(entry.getValue(), typeInformation, typeInformation.genericArguments[1]);
                result.put(resultKey, resultValue);
            }
            return result;
        }
        throw new RestResultException(new String[]{"could not convert Type " + resultObject.getClass().getName() + " to Type " + typeInformation.type.getName()});
    }

    private Iterable<?> toIterable(Object resultObject) {
        if (Iterable.class.isAssignableFrom(resultObject.getClass())) {
            return (Iterable)resultObject;
        }
        RestTableResultExtractor extractor = new RestTableResultExtractor(new RestEntityExtractor(this.restAPI));
        if (extractor.canHandle(resultObject)) {
            List<Map<String, Object>> data = extractor.extract((Map)resultObject);
            return data;
        }
        throw new RestResultException(new String[]{"could not convert Type " + resultObject.getClass().getName() + " to Iterable"});
    }

    private Map<?, ?> toMap(Object resultObject) {
        if (Map.class.isAssignableFrom(resultObject.getClass())) {
            return (Map)resultObject;
        }
        throw new RestResultException(new String[]{"could not convert Type " + resultObject.getClass().getName() + " to Map"});
    }

    private Object convertSingleTypeToResultType(Object resultObject, TypeInformation typeInformation, Class singleObjectType) {
        if (typeInformation.isInstance(resultObject, singleObjectType)) {
            return resultObject;
        }
        if (typeInformation.isGraphEntity(singleObjectType) && this.restEntityExtractor.canHandle(resultObject)) {
            return this.restEntityExtractor.convertFromRepresentation(resultObject);
        }
        if (typeInformation.isPath(singleObjectType) && resultObject instanceof Map) {
            return RestPathParser.parse((Map)resultObject, this.restAPI);
        }
        ConversionInfo resultInfo = this.convertFromCollectionType(resultObject, singleObjectType);
        if (resultInfo.isSuccessfulConversion()) {
            return resultInfo.getConversionData();
        }
        throw new RestResultException(new String[]{"could not convert Type " + resultObject.getClass().getName() + " to Type " + typeInformation.type.getName()});
    }

    private ConversionInfo convertFromCollectionType(Object resultObject, Class singleObjectType) {
        TypeInformation resultTypeInfo = new TypeInformation(resultObject);
        if (resultTypeInfo.isCollectionType()) {
            if (resultTypeInfo.isCollection()) {
                Iterable resultIterable = (Iterable)resultObject;
                if (!resultIterable.iterator().hasNext()) {
                    return new ConversionInfo(null, true);
                }
                if (this.iterableHasSingleElement(resultIterable) && resultTypeInfo.getGenericArguments()[0].equals(singleObjectType)) {
                    return new ConversionInfo(resultIterable.iterator().next(), true);
                }
            } else {
                Map resultMap = (Map)resultObject;
                if (resultMap.isEmpty()) {
                    return new ConversionInfo(null, true);
                }
                if (resultMap.size() == 1 && resultTypeInfo.getGenericArguments()[1].equals(singleObjectType)) {
                    return new ConversionInfo(resultMap.values().iterator().next(), true);
                }
            }
        }
        return new ConversionInfo(null, false);
    }

    public boolean iterableHasSingleElement(Iterable<?> object) {
        Iterator<?> it = object.iterator();
        if (!it.hasNext()) {
            return false;
        }
        it.next();
        return !it.hasNext();
    }
}

