/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.query;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.neo4j.rest.graphdb.RestAPICypherImpl;
import org.neo4j.rest.graphdb.query.CypherTransaction;
import org.neo4j.rest.graphdb.transaction.RemoteCypherTransaction;

public class RestCypherTransactionManager
implements TransactionManager,
Transaction {
    private static final ThreadLocal<RemoteCypherTransaction> cypherTransaction = new ThreadLocal();
    private final RestAPICypherImpl restAPICypher;

    public RestCypherTransactionManager(RestAPICypherImpl restAPICypher) {
        this.restAPICypher = restAPICypher;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.beginTx();
    }

    public org.neo4j.graphdb.Transaction beginTx() {
        RemoteCypherTransaction tx = cypherTransaction.get();
        if (tx != null && tx.isActive()) {
            tx.beginInner();
        } else {
            CypherTransaction newTx = this.restAPICypher.newCypherTransaction();
            tx = new RemoteCypherTransaction(newTx);
            cypherTransaction.set(tx);
        }
        return tx;
    }

    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        RemoteCypherTransaction tx = this.getRemoteCypherTransaction();
        tx.success();
        tx.close();
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        return false;
    }

    public boolean enlistResource(XAResource xaRes) throws IllegalStateException, RollbackException, SystemException {
        return false;
    }

    public void registerSynchronization(Synchronization synch) throws IllegalStateException, RollbackException, SystemException {
    }

    public int getStatus() throws SystemException {
        RemoteCypherTransaction tx = this.getRemoteCypherTransaction();
        if (tx == null || !tx.isActive()) {
            return 6;
        }
        return tx.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this;
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        RemoteCypherTransaction tx = this.getRemoteCypherTransaction();
        if (tx != null) {
            tx.failure();
            tx.close();
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.getRemoteCypherTransaction().failure();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
    }

    public Transaction suspend() throws SystemException {
        return this;
    }

    public void resume(Transaction tx) throws IllegalStateException, InvalidTransactionException, SystemException {
    }

    public boolean isActive() {
        RemoteCypherTransaction tx = this.getRemoteCypherTransaction();
        return tx != null && tx.isActive();
    }

    public CypherTransaction getCypherTransaction() {
        return this.getRemoteCypherTransaction().getTransaction();
    }

    public RemoteCypherTransaction getRemoteCypherTransaction() {
        return cypherTransaction.get();
    }
}

