/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.rest.graphdb.util;

import java.util.Iterator;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.collection.ClosableIterable;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.rest.graphdb.util.ConvertedResult;
import org.neo4j.rest.graphdb.util.DefaultConverter;
import org.neo4j.rest.graphdb.util.Handler;
import org.neo4j.rest.graphdb.util.QueryResult;
import org.neo4j.rest.graphdb.util.ResultConverter;

public class QueryResultBuilder<T>
implements QueryResult<T> {
    private Iterable<T> result;
    private final ResultConverter defaultConverter;
    private final boolean isClosableIterable;
    private boolean isClosed;

    public QueryResultBuilder(Iterable<T> result) {
        this(result, new DefaultConverter());
    }

    public QueryResultBuilder(Iterable<T> result, ResultConverter<T, ?> defaultConverter) {
        this.result = result;
        this.isClosableIterable = result instanceof IndexHits || result instanceof ClosableIterable || result instanceof AutoCloseable;
        this.defaultConverter = defaultConverter;
    }

    @Override
    public <R> ConvertedResult<R> to(Class<R> type) {
        return this.to(type, this.defaultConverter);
    }

    @Override
    public <R> ConvertedResult<R> to(final Class<R> type, final ResultConverter<T, R> resultConverter) {
        return new ConvertedResult<R>(){

            @Override
            public R single() {
                try {
                    Object value = IteratorUtil.single((Iterable)QueryResultBuilder.this.result);
                    Object r = resultConverter.convert(value, type);
                    return r;
                }
                finally {
                    QueryResultBuilder.this.closeIfNeeded();
                }
            }

            @Override
            public R singleOrNull() {
                try {
                    Object value = IteratorUtil.singleOrNull((Iterable)QueryResultBuilder.this.result);
                    Object r = resultConverter.convert(value, type);
                    return r;
                }
                finally {
                    QueryResultBuilder.this.closeIfNeeded();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(Handler<R> handler) {
                try {
                    for (Object value : QueryResultBuilder.this.result) {
                        handler.handle(resultConverter.convert(value, type));
                    }
                }
                finally {
                    QueryResultBuilder.this.closeIfNeeded();
                }
            }

            @Override
            public Iterator<R> iterator() {
                return new IteratorWrapper<R, T>(QueryResultBuilder.this.result.iterator()){

                    protected R underlyingObjectToObject(T value) {
                        return resultConverter.convert(value, type);
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Handler<T> handler) {
        try {
            for (T value : this.result) {
                handler.handle(value);
            }
        }
        finally {
            this.closeIfNeeded();
        }
    }

    private void closeIfNeeded() {
        if (this.isClosableIterable && !this.isClosed) {
            if (this.result instanceof IndexHits) {
                ((IndexHits)this.result).close();
            } else if (this.result instanceof ClosableIterable) {
                ((ClosableIterable)this.result).close();
            } else if (this.result instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)((Object)this.result)).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.isClosed = true;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.result.iterator();
    }
}

