/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.RelatedToFieldAccessor;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.mapping.RelationshipInfo;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public class RelatedToSingleFieldAccessorFactory
implements FieldAccessorFactory {
    protected Neo4jTemplate template;

    public RelatedToSingleFieldAccessorFactory(Neo4jTemplate template) {
        this.template = template;
    }

    @Override
    public boolean accept(Neo4jPersistentProperty property) {
        if (!property.isRelationship()) {
            return false;
        }
        return property.getRelationshipInfo().isRelatedTo() && property.getRelationshipInfo().isSingle();
    }

    @Override
    public FieldAccessor forField(Neo4jPersistentProperty property) {
        RelationshipInfo relationshipInfo = property.getRelationshipInfo();
        return new RelatedToSingleFieldAccessor(relationshipInfo.getRelationshipType(), relationshipInfo.getDirection(), relationshipInfo.getTargetType().getType(), this.template, property);
    }

    public static class RelatedToSingleFieldAccessor
    extends RelatedToFieldAccessor {
        public RelatedToSingleFieldAccessor(RelationshipType type, Direction direction, Class<?> clazz, Neo4jTemplate template, Neo4jPersistentProperty property) {
            super(clazz, template, direction, type, property);
        }

        @Override
        public Object setValue(Object entity, Object newVal, MappingPolicy mappingPolicy) {
            Node node = this.checkAndGetNode(entity);
            if (newVal == null) {
                this.removeMissingRelationships(node, Collections.<Node>emptySet());
                return null;
            }
            Set<Node> target = this.createSetOfTargetNodes(Collections.singleton(newVal));
            this.removeMissingRelationships(node, target, this.property.getTargetType());
            this.createAddedRelationships(node, target);
            return newVal;
        }

        @Override
        public Object getValue(Object entity, MappingPolicy mappingPolicy) {
            Set<Object> result;
            this.checkAndGetNode(entity);
            MappingPolicy currentPolicy = this.property.obtainMappingPolicy(mappingPolicy);
            Set<Object> set = result = this.property.isTargetTypeEnforced() ? this.createEntitySetFromRelationshipEndNodesUsingTypeProperty(entity, currentPolicy) : this.createEntitySetFromRelationshipEndNodes(entity, currentPolicy);
            if (result.isEmpty()) {
                return DoReturn.doReturn(null);
            }
            HashSet<Object> values = new HashSet<Object>();
            Class<?> targetType = this.property.getTargetType();
            for (Object value : result) {
                if (targetType != null && !targetType.isAssignableFrom(value.getClass())) continue;
                values.add(value);
            }
            if (values.size() == 0) {
                return DoReturn.doReturn(null);
            }
            if (values.size() == 1) {
                return DoReturn.doReturn(values.iterator().next());
            }
            throw new IllegalArgumentException("Cannot obtain single field value for field '" + this.property.getField().getName() + "'");
        }
    }
}

