/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URI;
import javax.annotation.PreDestroy;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.support.DelegatingGraphDatabase;

public class GraphDatabaseFactoryBean
implements FactoryBean<GraphDatabase> {
    private String storeLocation;
    private String userName;
    private String password;
    protected GraphDatabase graphDatabase;

    public String getStoreLocation() {
        return this.storeLocation;
    }

    public void setStoreLocation(String storeLocation) {
        this.storeLocation = storeLocation;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private GraphDatabase databaseFor(String url, String username, String password) throws Exception {
        if (url.startsWith("http://") || url.startsWith("https://")) {
            return this.createRestGraphDatabase(url, username, password);
        }
        String path = url;
        if (url.startsWith("file:")) {
            path = new URI(url).getPath();
        }
        File file = new File(path);
        return new DelegatingGraphDatabase(new GraphDatabaseFactory().newEmbeddedDatabase(file.getAbsolutePath()));
    }

    private GraphDatabase createRestGraphDatabase(String url, String username, String password) throws Exception {
        Class<?> restGraphDatabaseClass = Class.forName("org.neo4j.rest.graphdb.RestGraphDatabase");
        Constructor<?> constructor = restGraphDatabaseClass.getConstructor(URI.class, String.class, String.class);
        return (GraphDatabase)constructor.newInstance(new URI(url), username, password);
    }

    public GraphDatabase getObject() throws Exception {
        if (this.graphDatabase == null) {
            this.graphDatabase = this.databaseFor(this.storeLocation, this.userName, this.password);
        }
        return this.graphDatabase;
    }

    @PreDestroy
    public void shutdown() {
        if (this.graphDatabase instanceof DelegatingGraphDatabase) {
            ((DelegatingGraphDatabase)this.graphDatabase).shutdown();
        }
    }

    public Class<?> getObjectType() {
        return GraphDatabaseService.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

