/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.conversion;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.neo4j.annotation.MapResult;
import org.springframework.data.neo4j.annotation.QueryResult;
import org.springframework.data.neo4j.annotation.ResultColumn;
import org.springframework.data.neo4j.conversion.DefaultConverter;
import org.springframework.data.neo4j.conversion.QueryResultBuilder;
import org.springframework.data.neo4j.core.EntityPath;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.Neo4jTemplateAware;
import org.springframework.data.neo4j.support.conversion.POJOResultBuildingException;
import org.springframework.data.neo4j.support.conversion.QueryResultProxy;
import org.springframework.data.neo4j.support.conversion.ResultColumnValueExtractor;
import org.springframework.data.neo4j.support.path.ConvertingEntityPath;

public class EntityResultConverter<T, R>
extends DefaultConverter<T, R>
implements Neo4jTemplateAware<EntityResultConverter<T, R>> {
    private final ConversionService conversionService;
    private Neo4jTemplate template;

    public EntityResultConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public EntityResultConverter(ConversionService conversionService, Neo4jTemplate template) {
        this.conversionService = conversionService;
        this.template = template;
    }

    @Override
    public EntityResultConverter<T, R> with(Neo4jTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException("Template for EntityResultConverter must not be null");
        }
        this.template = template;
        return this;
    }

    @Override
    protected Object doConvert(Object value, Class<?> sourceType, Class targetType, MappingPolicy mappingPolicy) {
        if (EntityPath.class.isAssignableFrom(targetType)) {
            return new ConvertingEntityPath(this.toPath(value, sourceType), this.template);
        }
        if (this.template.isNodeEntity(targetType)) {
            return this.template.projectTo(this.toNode(value, sourceType), targetType, mappingPolicy);
        }
        if (this.template.isRelationshipEntity(targetType)) {
            return this.template.projectTo(this.toRelationship(value, sourceType), targetType, mappingPolicy);
        }
        Object result = super.doConvert(value, sourceType, targetType, mappingPolicy);
        if (result != null) {
            return result;
        }
        if (this.conversionService.canConvert(sourceType, targetType)) {
            return this.conversionService.convert(value, targetType);
        }
        return result;
    }

    public R extractPOJOResult(Object value, Class returnType, MappingPolicy mappingPolicy) {
        String errorMessage = "Error extracting and setting value for POJO Result : " + returnType;
        if (!Map.class.isAssignableFrom(value.getClass())) {
            throw new RuntimeException("QueryResult can only be extracted from Map<String,Object>.");
        }
        R newThing = null;
        ResultColumnValueExtractor resultColumnValueExtractor = new ResultColumnValueExtractor((Map)value, mappingPolicy, this);
        try {
            newThing = (R)returnType.newInstance();
            BeanWrapperImpl wrapper = new BeanWrapperImpl(newThing);
            for (Field field : returnType.getDeclaredFields()) {
                this.extractAndSetValueOfField((BeanWrapper)wrapper, field, resultColumnValueExtractor);
            }
        }
        catch (IllegalAccessException e1) {
            throw new POJOResultBuildingException(errorMessage, e1);
        }
        catch (InstantiationException e2) {
            throw new POJOResultBuildingException(errorMessage, e2);
        }
        catch (InvocationTargetException e3) {
            throw new POJOResultBuildingException(errorMessage, e3);
        }
        catch (NoSuchMethodException e4) {
            throw new POJOResultBuildingException(errorMessage, e4);
        }
        catch (ClassNotFoundException e5) {
            throw new POJOResultBuildingException(errorMessage, e5);
        }
        return newThing;
    }

    private void extractAndSetValueOfField(BeanWrapper wrapper, Field field, ResultColumnValueExtractor resultColumnValueExtractor) throws InvocationTargetException, NoSuchMethodException, ClassNotFoundException, IllegalAccessException {
        if (!this.isPOJOMappableField(field)) {
            return;
        }
        Object val = resultColumnValueExtractor.extractFromField(field);
        if (val != null) {
            if (val.getClass().getEnclosingClass() != null && val.getClass().getEnclosingClass().equals(QueryResultBuilder.class)) {
                val = IteratorUtil.asCollection((Iterable)((Iterable)val));
            }
            wrapper.setPropertyValue(field.getName(), val);
        }
    }

    private boolean isPOJOMappableField(Field field) {
        return field.getAnnotation(ResultColumn.class) != null;
    }

    public R extractProxyBasedResult(Object value, Class returnType, MappingPolicy mappingPolicy) {
        if (!Map.class.isAssignableFrom(value.getClass())) {
            throw new RuntimeException("MapResult can only be extracted from Map<String,Object>.");
        }
        QueryResultProxy handler = new QueryResultProxy((Map)value, mappingPolicy, this);
        return (R)Proxy.newProxyInstance(returnType.getClassLoader(), new Class[]{returnType}, (InvocationHandler)handler);
    }

    @Override
    public R convert(Object value, Class type, MappingPolicy mappingPolicy) {
        if (this.isInterfaceBasedMappingRequest(type)) {
            return this.extractProxyBasedResult(value, type, mappingPolicy);
        }
        if (this.isPojoBasedMappingReqest(type)) {
            return this.extractPOJOResult(value, type, mappingPolicy);
        }
        return super.convert(value, type, mappingPolicy);
    }

    boolean isInterfaceBasedMappingRequest(Class type) {
        return type.isInterface() && (type.isAnnotationPresent(MapResult.class) || type.isAnnotationPresent(QueryResult.class));
    }

    boolean isPojoBasedMappingReqest(Class type) {
        return !type.isInterface() && type.isAnnotationPresent(QueryResult.class);
    }
}

