/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support;

import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.tooling.GlobalGraphOperations;
import org.springframework.data.neo4j.core.GraphDatabaseGlobalOperations;

public class DelegatingGraphDatabaseGlobalOperations
implements GraphDatabaseGlobalOperations {
    private GraphDatabaseService graphDatabaseService;
    private GlobalGraphOperations globalGraphOperations;

    public DelegatingGraphDatabaseGlobalOperations(GraphDatabaseService delegate) {
        this.graphDatabaseService = delegate;
    }

    private GlobalGraphOperations getGlobalGraphOperations() {
        if (this.globalGraphOperations == null) {
            this.globalGraphOperations = GlobalGraphOperations.at((GraphDatabaseService)this.graphDatabaseService);
        }
        return this.globalGraphOperations;
    }

    @Override
    public ResourceIterable<Label> getAllLabels() {
        return this.getGlobalGraphOperations().getAllLabels();
    }

    @Override
    public ResourceIterable<Node> getAllNodesWithLabel(Label label) {
        return this.getGlobalGraphOperations().getAllNodesWithLabel(label);
    }
}

