/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support;

import java.util.Stack;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.NotInTransactionException;

public class Neo4jEmbeddedTransactionManager
implements TransactionManager,
Transaction {
    private static final ThreadLocal<Stack<TxState>> transaction = new ThreadLocal<Stack<TxState>>(){

        @Override
        protected Stack<TxState> initialValue() {
            return new Stack<TxState>();
        }
    };
    private final GraphDatabaseService graphDatabaseService;

    public Neo4jEmbeddedTransactionManager(GraphDatabaseService graphDatabaseService) {
        this.graphDatabaseService = graphDatabaseService;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.beginTx();
    }

    public org.neo4j.graphdb.Transaction beginTx() {
        org.neo4j.graphdb.Transaction tx = this.graphDatabaseService.beginTx();
        this.stack().push(TxState.begin(tx));
        return tx;
    }

    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        TxState tx = this.getTxState();
        if (tx == null) {
            throw new NotInTransactionException("Not in transaction");
        }
        try {
            tx.commit();
        }
        finally {
            this.stack().pop();
        }
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        return false;
    }

    public boolean enlistResource(XAResource xaRes) throws IllegalStateException, RollbackException, SystemException {
        return false;
    }

    public void registerSynchronization(Synchronization synch) throws IllegalStateException, RollbackException, SystemException {
    }

    public int getStatus() throws SystemException {
        TxState state = this.getTxState();
        if (state == null) {
            return 6;
        }
        return state.state;
    }

    public Transaction getTransaction() throws SystemException {
        return this;
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        TxState state = this.getTxState();
        if (state != null) {
            try {
                state.rollback();
            }
            finally {
                this.stack().pop();
            }
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        TxState state = this.getTxState();
        state.setRollbackOnly();
        this.getNeo4jTransaction().failure();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
    }

    public Transaction suspend() throws SystemException {
        return this;
    }

    public void resume(Transaction tx) throws IllegalStateException, InvalidTransactionException, SystemException {
    }

    public boolean isActive() {
        TxState tx = this.getTxState();
        return tx != null && tx.isActive();
    }

    public org.neo4j.graphdb.Transaction getNeo4jTransaction() {
        return this.getTxState().tx;
    }

    protected TxState getTxState() {
        return this.stack().isEmpty() ? null : this.stack().peek();
    }

    protected Stack<TxState> stack() {
        return transaction.get();
    }

    static class TxState {
        private int state = 6;
        private org.neo4j.graphdb.Transaction tx;

        TxState() {
        }

        boolean isActive() {
            return this.state == 0 || this.state == 1;
        }

        static TxState begin(org.neo4j.graphdb.Transaction tx) {
            TxState state = new TxState();
            state.tx = tx;
            state.state = 0;
            return state;
        }

        public void rollback() {
            this.state = 9;
            this.tx.failure();
            this.tx.close();
            this.state = 4;
        }

        public void commit() {
            this.state = 8;
            this.tx.success();
            this.tx.close();
            this.state = 3;
        }

        public void setRollbackOnly() {
            this.tx.failure();
            this.state = 1;
        }
    }
}

