/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.mapping;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.ClosableIterable;

public class ResourceIterableClosableIterable
implements ClosableIterable,
ResourceIterable {
    private ResourceIterable<Node> resourceIterable;
    private List<ResourceIterator> requestedIterators;

    public ResourceIterableClosableIterable(ResourceIterable<Node> resourceIterable) {
        this.resourceIterable = resourceIterable;
        this.requestedIterators = new ArrayList<ResourceIterator>();
    }

    public void close() {
        for (ResourceIterator ri : this.requestedIterators) {
            ri.close();
        }
    }

    public ResourceIterator iterator() {
        ResourceIterator ri = this.resourceIterable.iterator();
        this.requestedIterators.add(ri);
        return ri;
    }
}

