/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.examples.galaxy.service;

import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.session.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.examples.galaxy.domain.World;
import org.springframework.data.neo4j.examples.galaxy.repo.WorldRepository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GalaxyService {
    @Autowired
    private WorldRepository worldRepository;
    @Autowired
    Session session;

    public long getNumberOfWorlds() {
        return this.worldRepository.count();
    }

    public World createWorld(String name, int moons) {
        return (World)this.worldRepository.save(new World(name, moons));
    }

    public Iterable<World> getAllWorlds() {
        return this.worldRepository.findAll();
    }

    public World findWorldById(Long id) {
        return (World)this.worldRepository.findOne(id);
    }

    public World findWorldByName(String name) {
        Iterable<World> worlds = this.findByProperty("name", name);
        if (worlds.iterator().hasNext()) {
            return worlds.iterator().next();
        }
        return null;
    }

    public Iterable<World> findAllByNumberOfMoons(int numberOfMoons) {
        return this.findByProperty("moons", numberOfMoons);
    }

    public Collection<World> makeSomeWorlds() {
        ArrayList<World> worlds = new ArrayList<World>();
        worlds.add(this.createWorld("Mercury", 0));
        worlds.add(this.createWorld("Venus", 0));
        World earth = this.createWorld("Earth", 1);
        World mars = this.createWorld("Mars", 2);
        mars.addRocketRouteTo(earth);
        this.worldRepository.save(mars);
        worlds.add(earth);
        worlds.add(mars);
        worlds.add(this.createWorld("Jupiter", 63));
        worlds.add(this.createWorld("Saturn", 62));
        worlds.add(this.createWorld("Uranus", 27));
        worlds.add(this.createWorld("Neptune", 13));
        worlds.add(this.createWorld("Alfheimr", 0));
        worlds.add(this.createWorld("Midgard", 1));
        worlds.add(this.createWorld("Muspellheim", 2));
        worlds.add(this.createWorld("Asgard", 63));
        worlds.add(this.createWorld("Hel", 62));
        return worlds;
    }

    public Collection<World> makeAllWorldsAtOnce() {
        ArrayList<World> worlds = new ArrayList<World>();
        worlds.add(new World("Mercury", 0));
        worlds.add(new World("Venus", 0));
        World earth = new World("Earth", 1);
        World mars = new World("Mars", 2);
        mars.addRocketRouteTo(earth);
        earth.addRocketRouteTo(mars);
        worlds.add(earth);
        worlds.add(mars);
        worlds.add(new World("Jupiter", 63));
        worlds.add(new World("Saturn", 62));
        worlds.add(new World("Uranus", 27));
        worlds.add(new World("Neptune", 13));
        worlds.add(new World("Alfheimr", 0));
        worlds.add(new World("Midgard", 1));
        worlds.add(new World("Muspellheim", 2));
        worlds.add(new World("Asgard", 63));
        worlds.add(new World("Hel", 62));
        this.worldRepository.save(worlds);
        return worlds;
    }

    public void deleteAll() {
        this.worldRepository.deleteAll();
    }

    private Iterable<World> findByProperty(String propertyName, Object propertyValue) {
        return this.session.loadAll(World.class, new Filter(propertyName, propertyValue));
    }

    public Iterable<World> findByProperty(String propertyName, Object propertyValue, int depth) {
        return this.session.loadAll(World.class, new Filter(propertyName, propertyValue), depth);
    }

    public Iterable<World> findAllWorlds(Pagination paging) {
        return this.session.loadAll(World.class, paging, 0);
    }

    public Iterable<World> findAllWorlds(Sort sort) {
        return this.worldRepository.findAll(sort, 0);
    }

    public Page<World> findAllWorlds(Pageable pageable) {
        return this.worldRepository.findAll(pageable, 0);
    }

    public Iterable<World> findAllWorlds(Sort sort, int depth) {
        return this.worldRepository.findAll(sort, depth);
    }
}

