/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.examples.jsr303;

import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.examples.jsr303.JSR303Context;
import org.springframework.data.neo4j.examples.jsr303.WebConfiguration;
import org.springframework.data.neo4j.examples.jsr303.domain.Adult;
import org.springframework.data.neo4j.examples.jsr303.service.AdultService;
import org.springframework.http.MediaType;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@ContextConfiguration(classes={WebConfiguration.class, JSR303Context.class})
@WebAppConfiguration
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class JSR303Test {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    @Autowired
    private AdultService service;
    @Autowired
    WebApplicationContext wac;
    private MockMvc mockMvc;

    @Before
    public void setUp() {
        this.mockMvc = MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.wac).build();
    }

    @Test
    public void testCanCreateAnAdult() throws Exception {
        Adult adult = new Adult("Peter", 18);
        String json = objectMapper.writeValueAsString((Object)adult);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/adults", (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(json)).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void testCantCreateAnAdultUnderEighteen() throws Exception {
        Adult adult = new Adult("Peter", 16);
        String json = objectMapper.writeValueAsString((Object)adult);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/adults", (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(json)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }
}

