/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.examples.movies.domain;

import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.StartNode;
import org.springframework.data.neo4j.examples.movies.domain.TempMovie;
import org.springframework.data.neo4j.examples.movies.domain.User;

@RelationshipEntity(type="RATED")
public class Rating
implements Comparable {
    private Long id;
    @StartNode
    private User user;
    @EndNode
    private TempMovie movie;
    private int stars;
    private String comment;
    private long ratingTimestamp;

    public Rating() {
    }

    public Rating(User user, TempMovie movie, int stars, String comment) {
        this.user = user;
        this.movie = movie;
        this.stars = stars;
        this.comment = comment;
    }

    public Long getId() {
        return this.id;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setMovie(TempMovie movie) {
        this.movie = movie;
    }

    public void setStars(int stars) {
        this.stars = stars;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public User getUser() {
        return this.user;
    }

    public TempMovie getMovie() {
        return this.movie;
    }

    public int getStars() {
        return this.stars;
    }

    public String getComment() {
        return this.comment;
    }

    public long getRatingTimestamp() {
        return this.ratingTimestamp;
    }

    public void setRatingTimestamp(long ratingTimestamp) {
        this.ratingTimestamp = ratingTimestamp;
    }

    public int compareTo(Object o) {
        Rating other = (Rating)o;
        if (this.stars == ((Rating)o).getStars()) {
            return this.getUser().getName().compareTo(other.getUser().getName());
        }
        return this.stars - other.getStars();
    }
}

