/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.queries;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.Neo4jIntegrationTestRule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.examples.movies.context.MoviesContext;
import org.springframework.data.neo4j.examples.movies.domain.Rating;
import org.springframework.data.neo4j.examples.movies.domain.TempMovie;
import org.springframework.data.neo4j.examples.movies.domain.User;
import org.springframework.data.neo4j.examples.movies.repo.CinemaRepository;
import org.springframework.data.neo4j.examples.movies.repo.RatingRepository;
import org.springframework.data.neo4j.examples.movies.repo.UserRepository;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(classes={MoviesContext.class})
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class DerivedRelationshipEntityQueryTest {
    @ClassRule
    public static Neo4jIntegrationTestRule neo4jRule = new Neo4jIntegrationTestRule(7879);
    private static Session session;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private CinemaRepository cinemaRepository;
    @Autowired
    private RatingRepository ratingRepository;

    @Before
    public void init() throws IOException {
        session = new SessionFactory(new String[]{"org.springframework.data.neo4j.examples.movies.domain"}).openSession(neo4jRule.url());
    }

    @After
    public void clearDatabase() {
        neo4jRule.clearDatabase();
    }

    private void executeUpdate(String cypher) {
        new ExecutionEngine(neo4jRule.getGraphDatabaseService()).execute(cypher);
    }

    @Test
    public void shouldFindREWithSingleProperty() {
        User critic = new User("Gary");
        TempMovie film = new TempMovie("Fast and Furious XVII");
        Rating filmRating = critic.rate(film, 2, "They've made far too many of these films now!");
        this.userRepository.save(critic);
        List<Rating> ratings = this.ratingRepository.findByStars(2);
        Assert.assertNotNull(ratings);
        Rating loadedRating = ratings.get(0);
        Assert.assertNotNull((String)"The loaded rating shouldn't be null", (Object)loadedRating);
        Assert.assertEquals((String)"The relationship properties weren't saved correctly", (long)filmRating.getStars(), (long)loadedRating.getStars());
        Assert.assertEquals((String)"The rated film wasn't saved correctly", (Object)film.getName(), (Object)loadedRating.getMovie().getName());
        Assert.assertEquals((String)"The critic wasn't saved correctly", (Object)critic.getId(), (Object)loadedRating.getUser().getId());
    }

    @Test
    public void shouldFindREWithMultiplePropertiesAnded() {
        User critic = new User("Gary");
        TempMovie film = new TempMovie("Fast and Furious XVII");
        Rating filmRating = critic.rate(film, 2, "They've made far too many of these films now!");
        filmRating.setRatingTimestamp(1000L);
        this.userRepository.save(critic);
        List<Rating> ratings = this.ratingRepository.findByStarsAndRatingTimestamp(2, 1000L);
        Assert.assertNotNull(ratings);
        Rating loadedRating = ratings.get(0);
        Assert.assertNotNull((String)"The loaded rating shouldn't be null", (Object)loadedRating);
        Assert.assertEquals((String)"The relationship properties weren't saved correctly", (long)filmRating.getStars(), (long)loadedRating.getStars());
        Assert.assertEquals((String)"The rated film wasn't saved correctly", (Object)film.getName(), (Object)loadedRating.getMovie().getName());
        Assert.assertEquals((String)"The critic wasn't saved correctly", (Object)critic.getId(), (Object)loadedRating.getUser().getId());
        ratings = this.ratingRepository.findByStarsAndRatingTimestamp(2, 2000L);
        Assert.assertEquals((long)0L, (long)ratings.size());
    }

    @Test
    public void shouldFindREWithMultiplePropertiesOred() {
        User critic = new User("Gary");
        TempMovie film = new TempMovie("Fast and Furious XVII");
        Rating filmRating = critic.rate(film, 2, "They've made far too many of these films now!");
        filmRating.setRatingTimestamp(1000L);
        this.userRepository.save(critic);
        List<Rating> ratings = this.ratingRepository.findByStarsOrRatingTimestamp(5, 1000L);
        Assert.assertNotNull(ratings);
        Rating loadedRating = ratings.get(0);
        Assert.assertNotNull((String)"The loaded rating shouldn't be null", (Object)loadedRating);
        Assert.assertEquals((String)"The relationship properties weren't saved correctly", (long)filmRating.getStars(), (long)loadedRating.getStars());
        Assert.assertEquals((String)"The rated film wasn't saved correctly", (Object)film.getName(), (Object)loadedRating.getMovie().getName());
        Assert.assertEquals((String)"The critic wasn't saved correctly", (Object)critic.getId(), (Object)loadedRating.getUser().getId());
        ratings = this.ratingRepository.findByStarsAndRatingTimestamp(5, 2000L);
        Assert.assertEquals((long)0L, (long)ratings.size());
    }

    @Test
    public void shouldFindREWithMultiplePropertiesDifferentComparisonOperatorsAnded() {
        User critic = new User("Gary");
        TempMovie film = new TempMovie("Fast and Furious XVII");
        Rating filmRating = critic.rate(film, 2, "They've made far too many of these films now!");
        filmRating.setRatingTimestamp(1000L);
        this.userRepository.save(critic);
        List<Rating> ratings = this.ratingRepository.findByStarsAndRatingTimestampLessThan(2, 2000L);
        Assert.assertNotNull(ratings);
        Rating loadedRating = ratings.get(0);
        Assert.assertNotNull((String)"The loaded rating shouldn't be null", (Object)loadedRating);
        Assert.assertEquals((String)"The relationship properties weren't saved correctly", (long)filmRating.getStars(), (long)loadedRating.getStars());
        Assert.assertEquals((String)"The rated film wasn't saved correctly", (Object)film.getName(), (Object)loadedRating.getMovie().getName());
        Assert.assertEquals((String)"The critic wasn't saved correctly", (Object)critic.getId(), (Object)loadedRating.getUser().getId());
        ratings = this.ratingRepository.findByStarsAndRatingTimestamp(2, 3000L);
        Assert.assertEquals((long)0L, (long)ratings.size());
    }

    @Test
    public void shouldFindREWithMultiplePropertiesDifferentComparisonOperatorsOred() {
        User critic = new User("Gary");
        TempMovie film = new TempMovie("Fast and Furious XVII");
        Rating filmRating = critic.rate(film, 2, "They've made far too many of these films now!");
        filmRating.setRatingTimestamp(1000L);
        this.userRepository.save(critic);
        List<Rating> ratings = this.ratingRepository.findByStarsOrRatingTimestampGreaterThan(5, 500L);
        Assert.assertNotNull(ratings);
        Rating loadedRating = ratings.get(0);
        Assert.assertNotNull((String)"The loaded rating shouldn't be null", (Object)loadedRating);
        Assert.assertEquals((String)"The relationship properties weren't saved correctly", (long)filmRating.getStars(), (long)loadedRating.getStars());
        Assert.assertEquals((String)"The rated film wasn't saved correctly", (Object)film.getName(), (Object)loadedRating.getMovie().getName());
        Assert.assertEquals((String)"The critic wasn't saved correctly", (Object)critic.getId(), (Object)loadedRating.getUser().getId());
        ratings = this.ratingRepository.findByStarsAndRatingTimestamp(5, 2000L);
        Assert.assertEquals((long)0L, (long)ratings.size());
    }

    @Test
    public void shouldFindRelEntitiesWithNestedStartNodeProperty() {
        this.executeUpdate("CREATE (m1:Movie {name:'Speed'}) CREATE (m2:Movie {name:'The Matrix'}) CREATE (m:Movie {name:'Chocolat'}) CREATE (u:User {name:'Michal'}) CREATE (u)-[:RATED {stars:3}]->(m1)  CREATE (u)-[:RATED {stars:4}]->(m2)");
        List<Rating> ratings = this.ratingRepository.findByUserName("Michal");
        Assert.assertEquals((long)2L, (long)ratings.size());
        Collections.sort(ratings);
        Assert.assertEquals((Object)"Speed", (Object)ratings.get(0).getMovie().getName());
        Assert.assertEquals((Object)"The Matrix", (Object)ratings.get(1).getMovie().getName());
    }

    @Test
    public void shouldFindRelEntitiesWithNestedEndNodeProperty() {
        this.executeUpdate("CREATE (m1:Movie {name:'Speed'}) CREATE (m2:Movie {name:'The Matrix'}) CREATE (m:Movie {name:'Chocolat'}) CREATE (u:User {name:'Michal'}) CREATE (u)-[:RATED {stars:3}]->(m1)  CREATE (u)-[:RATED {stars:4}]->(m2)");
        List<Rating> ratings = this.ratingRepository.findByMovieName("The Matrix");
        Assert.assertEquals((long)1L, (long)ratings.size());
        Assert.assertEquals((Object)"Michal", (Object)ratings.get(0).getUser().getName());
        Assert.assertEquals((Object)"The Matrix", (Object)ratings.get(0).getMovie().getName());
        Assert.assertEquals((long)4L, (long)ratings.get(0).getStars());
        ratings = this.ratingRepository.findByMovieName("Chocolat");
        Assert.assertEquals((long)0L, (long)ratings.size());
    }

    @Test
    public void shouldFindRelEntitiesWithBothStartEndNestedProperty() {
        this.executeUpdate("CREATE (m1:Movie {name:'Speed'}) CREATE (m2:Movie {name:'The Matrix'}) CREATE (m:Movie {name:'Chocolat'}) CREATE (u:User {name:'Michal'}) CREATE (u)-[:RATED {stars:3}]->(m1)  CREATE (u)-[:RATED {stars:4}]->(m2)");
        List<Rating> ratings = this.ratingRepository.findByUserNameAndMovieName("Michal", "Speed");
        Assert.assertEquals((long)1L, (long)ratings.size());
        Assert.assertEquals((Object)"Michal", (Object)ratings.get(0).getUser().getName());
        Assert.assertEquals((Object)"Speed", (Object)ratings.get(0).getMovie().getName());
        Assert.assertEquals((long)3L, (long)ratings.get(0).getStars());
        ratings = this.ratingRepository.findByUserNameAndMovieName("Michal", "Chocolat");
        Assert.assertEquals((long)0L, (long)ratings.size());
    }

    @Test
    public void shouldFindRelEntitiesWithBaseAndNestedStartNodePropertyAnded() {
        this.executeUpdate("CREATE (m1:Movie {name:'Speed'}) CREATE (m2:Movie {name:'The Matrix'}) CREATE (m:Movie {name:'Chocolat'}) CREATE (u:User {name:'Michal'}) CREATE (u)-[:RATED {stars:3}]->(m1)  CREATE (u)-[:RATED {stars:4}]->(m2)");
        List<Rating> ratings = this.ratingRepository.findByUserNameAndStars("Michal", 3);
        Assert.assertEquals((long)1L, (long)ratings.size());
        Assert.assertEquals((Object)"Michal", (Object)ratings.get(0).getUser().getName());
        Assert.assertEquals((Object)"Speed", (Object)ratings.get(0).getMovie().getName());
        Assert.assertEquals((long)3L, (long)ratings.get(0).getStars());
        ratings = this.ratingRepository.findByUserNameAndStars("Michal", 1);
        Assert.assertEquals((long)0L, (long)ratings.size());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldFindRelEntitiesWithBaseAndNestedStartNodePropertyOred() {
        this.executeUpdate("CREATE (m1:Movie {name:'Speed'}) CREATE (m2:Movie {name:'The Matrix'}) CREATE (m:Movie {name:'Chocolat'}) CREATE (u:User {name:'Michal'}) CREATE (u2:User {name:'Vince'})   CREATE (u)-[:RATED {stars:2}]->(m1)  CREATE (u)-[:RATED {stars:4}]->(m2) CREATE (u2)-[:RATED {stars:3}]->(m)");
        List<Rating> ratings = this.ratingRepository.findByStarsOrUserName(3, "Michal");
        Assert.assertEquals((long)3L, (long)ratings.size());
        Collections.sort(ratings);
        Assert.assertEquals((Object)"Speed", (Object)ratings.get(0).getMovie().getName());
        Assert.assertEquals((Object)"Chocolat", (Object)ratings.get(1).getMovie().getName());
        Assert.assertEquals((Object)"The Matrix", (Object)ratings.get(2).getMovie().getName());
        ratings = this.ratingRepository.findByStarsOrUserName(0, "Vince");
        Assert.assertEquals((long)0L, (long)ratings.size());
    }

    @Test
    public void shouldFindRelEntitiesWithBaseAndNestedEndNodeProperty() {
        this.executeUpdate("CREATE (m1:Movie {name:'Speed'}) CREATE (m2:Movie {name:'The Matrix'}) CREATE (m:Movie {name:'Chocolat'}) CREATE (u:User {name:'Michal'}) CREATE (u2:User {name:'Vince'})  CREATE (u)-[:RATED {stars:3}]->(m1)  CREATE (u)-[:RATED {stars:4}]->(m2) CREATE (u2)-[:RATED {stars:4}]->(m2)");
        List<Rating> ratings = this.ratingRepository.findByStarsAndMovieName(4, "The Matrix");
        Assert.assertEquals((long)2L, (long)ratings.size());
        Collections.sort(ratings);
        Assert.assertEquals((Object)"Michal", (Object)ratings.get(0).getUser().getName());
        Assert.assertEquals((Object)"Vince", (Object)ratings.get(1).getUser().getName());
        ratings = this.ratingRepository.findByStarsAndMovieName(5, "The Matrix");
        Assert.assertEquals((long)0L, (long)ratings.size());
    }

    @Test
    public void shouldFindRelEntitiesWithBaseAndBothStartEndNestedProperty() {
        this.executeUpdate("CREATE (m1:Movie {name:'Speed'}) CREATE (m2:Movie {name:'The Matrix'}) CREATE (m:Movie {name:'Chocolat'}) CREATE (u:User {name:'Michal'}) CREATE (u)-[:RATED {stars:3}]->(m1)  CREATE (u)-[:RATED {stars:4}]->(m2)");
        List<Rating> ratings = this.ratingRepository.findByUserNameAndMovieNameAndStars("Michal", "Speed", 3);
        Assert.assertEquals((long)1L, (long)ratings.size());
        Assert.assertEquals((Object)"Michal", (Object)ratings.get(0).getUser().getName());
        Assert.assertEquals((Object)"Speed", (Object)ratings.get(0).getMovie().getName());
        Assert.assertEquals((long)3L, (long)ratings.get(0).getStars());
        ratings = this.ratingRepository.findByUserNameAndMovieNameAndStars("Michal", "Speed", 0);
        Assert.assertEquals((long)0L, (long)ratings.size());
    }

    @Test
    public void shouldFindRelEntitiesWithTwoStartNodeNestedProperties() {
        this.executeUpdate("CREATE (m1:Movie {name:'Speed'}) CREATE (m2:Movie {name:'The Matrix'}) CREATE (m:Movie {name:'Chocolat'}) CREATE (u:User {name:'Michal', middleName:'M'}) CREATE (u2:User {name:'Vince', middleName:'M'})  CREATE (u)-[:RATED {stars:3}]->(m1)  CREATE (u)-[:RATED {stars:4}]->(m2) CREATE (u2)-[:RATED {stars:4}]->(m2)");
        List<Rating> ratings = this.ratingRepository.findByUserNameAndUserMiddleName("Michal", "M");
        Assert.assertEquals((long)2L, (long)ratings.size());
        Collections.sort(ratings);
        Assert.assertEquals((Object)"Michal", (Object)ratings.get(0).getUser().getName());
        Assert.assertEquals((Object)"Speed", (Object)ratings.get(0).getMovie().getName());
        Assert.assertEquals((Object)"Michal", (Object)ratings.get(1).getUser().getName());
        Assert.assertEquals((Object)"The Matrix", (Object)ratings.get(1).getMovie().getName());
        ratings = this.ratingRepository.findByUserNameAndUserMiddleName("Michal", "V");
        Assert.assertEquals((long)0L, (long)ratings.size());
    }
}

