/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repositories;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.GraphTestUtils;
import org.neo4j.ogm.testutil.Neo4jIntegrationTestRule;
import org.springframework.data.neo4j.repositories.domain.Movie;
import org.springframework.data.neo4j.repositories.repo.MovieRepository;
import org.springframework.data.neo4j.repository.support.GraphRepositoryFactory;
import org.springframework.data.neo4j.util.IterableUtils;

public class ProgrammaticRepositoryTest {
    @Rule
    public final Neo4jIntegrationTestRule neo4jRule = new Neo4jIntegrationTestRule(7879);
    private MovieRepository movieRepository;

    @Test
    public void canInstantiateRepositoryProgrammatically() {
        GraphRepositoryFactory factory = new GraphRepositoryFactory(new SessionFactory(new String[]{"org.springframework.data.neo4j.repositories.domain"}).openSession(this.neo4jRule.url()));
        this.movieRepository = (MovieRepository)factory.getRepository(MovieRepository.class);
        Movie movie = new Movie("PF");
        this.movieRepository.save(movie);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)this.neo4jRule.getGraphDatabaseService(), (String)"CREATE (m:Movie {title:'PF'})");
        Assert.assertEquals((long)1L, (long)IterableUtils.count(this.movieRepository.findAll()));
    }
}

