/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repositories;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.ogm.testutil.GraphTestUtils;
import org.neo4j.ogm.testutil.Neo4jIntegrationTestRule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.repositories.context.RepositoriesTestContext;
import org.springframework.data.neo4j.repositories.domain.Movie;
import org.springframework.data.neo4j.repositories.repo.MovieRepository;
import org.springframework.data.neo4j.util.IterableUtils;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(classes={RepositoriesTestContext.class})
@RunWith(value=SpringJUnit4ClassRunner.class)
public class RepositoryDefinitionTest {
    @Rule
    public final Neo4jIntegrationTestRule neo4jRule = new Neo4jIntegrationTestRule(7879);
    @Autowired
    private MovieRepository movieRepository;

    @Test
    public void shouldProxyAndAutoImplementRepositoryDefinitionAnnotatedRepo() {
        Movie movie = new Movie("PF");
        this.movieRepository.save(movie);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)this.neo4jRule.getGraphDatabaseService(), (String)"CREATE (m:Movie {title:'PF'})");
        Assert.assertEquals((long)1L, (long)IterableUtils.count(this.movieRepository.findAll()));
    }
}

