/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.template;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.event.AfterDeleteEvent;
import org.springframework.data.neo4j.event.AfterSaveEvent;
import org.springframework.data.neo4j.event.BeforeDeleteEvent;
import org.springframework.data.neo4j.event.BeforeSaveEvent;
import org.springframework.data.neo4j.examples.movies.domain.Actor;
import org.springframework.data.neo4j.template.Neo4jOperations;
import org.springframework.data.neo4j.template.TestNeo4jEventListener;
import org.springframework.data.neo4j.template.context.DataManipulationEventConfiguration;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(classes={DataManipulationEventConfiguration.class})
@RunWith(value=SpringJUnit4ClassRunner.class)
public class TemplateApplicationEventTest {
    @Autowired
    private Neo4jOperations neo4jTemplate;
    @Autowired
    private TestNeo4jEventListener<BeforeSaveEvent> beforeSaveEventListener;
    @Autowired
    private TestNeo4jEventListener<AfterSaveEvent> afterSaveEventListener;
    @Autowired
    private TestNeo4jEventListener<BeforeDeleteEvent> beforeDeleteEventListener;
    @Autowired
    private TestNeo4jEventListener<AfterDeleteEvent> afterDeleteEventListener;

    @Test
    public void shouldCreateTemplateAndPublishAppropriateApplicationEventsOnSaveAndOnDelete() {
        Assert.assertNotNull((String)"The Neo4jTemplate wasn't autowired into this test", (Object)this.neo4jTemplate);
        Actor entity = new Actor();
        entity.setName("John Abraham");
        Assert.assertFalse((boolean)this.beforeSaveEventListener.hasReceivedAnEvent());
        Assert.assertFalse((boolean)this.afterSaveEventListener.hasReceivedAnEvent());
        this.neo4jTemplate.save((Object)entity);
        Assert.assertTrue((boolean)this.beforeSaveEventListener.hasReceivedAnEvent());
        Assert.assertSame((Object)entity, (Object)this.beforeSaveEventListener.getEvent().getEntity());
        Assert.assertTrue((boolean)this.afterSaveEventListener.hasReceivedAnEvent());
        Assert.assertSame((Object)entity, (Object)this.afterSaveEventListener.getEvent().getEntity());
        Assert.assertFalse((boolean)this.beforeDeleteEventListener.hasReceivedAnEvent());
        Assert.assertFalse((boolean)this.afterDeleteEventListener.hasReceivedAnEvent());
        this.neo4jTemplate.delete((Object)entity);
        Assert.assertTrue((boolean)this.beforeDeleteEventListener.hasReceivedAnEvent());
        Assert.assertSame((Object)entity, (Object)this.beforeDeleteEventListener.getEvent().getEntity());
        Assert.assertTrue((boolean)this.afterDeleteEventListener.hasReceivedAnEvent());
        Assert.assertSame((Object)entity, (Object)this.afterDeleteEventListener.getEvent().getEntity());
    }
}

