/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.transactions;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.ogm.testutil.Neo4jIntegrationTestRule;
import org.neo4j.tooling.GlobalGraphOperations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.examples.movies.context.MoviesContext;
import org.springframework.data.neo4j.examples.movies.domain.User;
import org.springframework.data.neo4j.examples.movies.repo.UserRepository;
import org.springframework.data.neo4j.examples.movies.service.UserService;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(classes={MoviesContext.class})
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class TransactionIntegrationTest {
    @Rule
    public final Neo4jIntegrationTestRule neo4jRule = new Neo4jIntegrationTestRule(7879);
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserService userService;

    @Before
    public void populateDatabase() {
        this.neo4jRule.getGraphDatabaseService().registerTransactionEventHandler((TransactionEventHandler)new TransactionEventHandler.Adapter<Object>(){

            public Object beforeCommit(TransactionData data) throws Exception {
                System.out.println("The request to commit is denied");
                throw new TransactionInterceptException("Deliberate testing exception");
            }
        });
    }

    @Test(expected=Exception.class)
    public void whenImplicitTransactionFailsNothingShouldBeCreated() {
        try {
            this.userRepository.save(new User("Michal"));
            Assert.fail((String)"should have thrown exception");
        }
        catch (Exception e) {
            this.parseExceptionMessage(e.getLocalizedMessage());
            this.checkDatabase();
        }
    }

    private void parseExceptionMessage(String localizedMessage) {
        String parsed = localizedMessage.replace("{", "{\n");
        parsed = parsed.replace("\\n\\tat", "\n\tat");
        parsed = parsed.replace("},{", "},\n{");
        parsed = parsed.replace("\\n", "\n");
        System.out.println(parsed);
    }

    @Test(expected=Exception.class)
    public void whenExplicitTransactionFailsNothingShouldBeCreated() {
        try {
            this.userService.saveWithTxAnnotationOnInterface(new User("Michal"));
            Assert.fail((String)"should have thrown exception");
        }
        catch (Exception e) {
            this.parseExceptionMessage(e.getLocalizedMessage());
            this.checkDatabase();
        }
    }

    @Test(expected=Exception.class)
    public void whenExplicitTransactionFailsNothingShouldBeCreated2() {
        try {
            this.userService.saveWithTxAnnotationOnImpl(new User("Michal"));
            Assert.fail((String)"should have thrown exception");
        }
        catch (Exception e) {
            this.parseExceptionMessage(e.getLocalizedMessage());
            this.checkDatabase();
        }
    }

    private void checkDatabase() {
        try (Transaction tx = this.neo4jRule.getGraphDatabaseService().beginTx();){
            Assert.assertFalse((boolean)GlobalGraphOperations.at((GraphDatabaseService)this.neo4jRule.getGraphDatabaseService()).getAllNodes().iterator().hasNext());
            tx.success();
        }
    }

    static class TransactionInterceptException
    extends Exception {
        public TransactionInterceptException(String msg) {
            super(msg);
        }
    }
}

