/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.util;

import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.ogm.exception.NotFoundException;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.springframework.data.neo4j.util.IterableUtils;

public class IterableUtilsTest {
    @Test
    public void checkContainsCollections() {
        Assert.assertTrue((boolean)IterableUtils.contains(Arrays.asList("a", "b"), (Object)"b"));
        Assert.assertFalse((boolean)IterableUtils.contains(Arrays.asList("a", "b"), (Object)"c"));
    }

    @Test
    public void checkContainsRealIterables() {
        Node node;
        GraphDatabaseService database = new TestGraphDatabaseFactory().newImpermanentDatabase();
        try (Transaction tx = database.beginTx();){
            node = database.createNode();
            tx.success();
        }
        tx = database.beginTx();
        var4_3 = null;
        try {
            Assert.assertTrue((boolean)IterableUtils.contains((Iterable)database.getAllNodes(), (Object)node));
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = database.beginTx();
        var4_3 = null;
        try {
            database.getNodeById(0L).delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = database.beginTx();
        var4_3 = null;
        try {
            Assert.assertFalse((boolean)IterableUtils.contains((Iterable)database.getAllNodes(), (Object)node));
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        database.shutdown();
    }

    @Test
    public void singleElementShouldBeReturnedWhenIterableHasOneElement() {
        Assert.assertEquals((Object)"test", (Object)IterableUtils.getSingleOrNull(Collections.singletonList("test")));
    }

    @Test
    public void singleElementShouldBeReturnedWhenIterableHasOneElement2() {
        Assert.assertEquals((Object)"test", (Object)IterableUtils.getSingle(Collections.singletonList("test")));
    }

    @Test
    public void nullShouldBeReturnedWhenIterableHasNoElements() {
        Assert.assertNull((Object)IterableUtils.getSingleOrNull(Collections.emptyList()));
    }

    @Test(expected=NotFoundException.class)
    public void exceptionShouldBeThrownWhenIterableHasNoElements() {
        IterableUtils.getSingle(Collections.emptyList());
    }

    @Test
    public void exceptionShouldBeThrownWhenIterableHasNoElements2() {
        try {
            IterableUtils.getSingle(Collections.emptyList(), (String)"test");
        }
        catch (NotFoundException e) {
            Assert.assertEquals((Object)"test", (Object)e.getMessage());
        }
    }

    @Test(expected=IllegalStateException.class)
    public void exceptionShouldBeThrownWhenIterableHasMoreThanOneElement() {
        IterableUtils.getSingleOrNull(Arrays.asList("test1", "test2"));
    }

    @Test(expected=IllegalStateException.class)
    public void exceptionShouldBeThrownWhenIterableHasMoreThanOneElement2() {
        IterableUtils.getSingle(Arrays.asList("test1", "test2"));
    }

    @Test
    public void firstElementShouldBeReturnedWhenIterableHasOneElement() {
        Assert.assertEquals((Object)"test", (Object)IterableUtils.getFirstOrNull(Collections.singletonList("test")));
    }

    @Test
    public void firstElementShouldBeReturnedWhenIterableHasOneElement2() {
        Assert.assertEquals((Object)"test", (Object)IterableUtils.getFirst(Collections.singletonList("test"), (String)"test"));
    }

    @Test
    public void nullShouldBeReturnedWhenIterableHasNoElementsWhenRequestingFirst() {
        Assert.assertNull((Object)IterableUtils.getFirstOrNull(Collections.emptyList()));
    }

    @Test(expected=NotFoundException.class)
    public void exceptionShouldBeThrownWhenIterableHasNoElementsWhenRequestingFirst() {
        IterableUtils.getFirst(Collections.emptyList(), (String)"test");
    }

    @Test
    public void exceptionShouldBeThrownWhenIterableHasNoElements2WhenRequestingFirst() {
        try {
            IterableUtils.getFirst(Collections.emptyList(), (String)"test");
        }
        catch (NotFoundException e) {
            Assert.assertEquals((Object)"test", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldReturnFirstWhenThereIsMoreThanOne() {
        Assert.assertEquals((Object)"test1", (Object)IterableUtils.getFirstOrNull(Arrays.asList("test1", "test2")));
    }

    @Test
    public void exceptionShouldBeThrownWhenIterableHasMoreThanOneElement2WhenRequestingFirst() {
        Assert.assertEquals((Object)"test1", (Object)IterableUtils.getFirst(Arrays.asList("test1", "test2"), (String)"test"));
    }
}

