/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.web.context;

import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.repository.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.server.InProcessServer;
import org.springframework.data.neo4j.server.Neo4jServer;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@ComponentScan(value={"org.springframework.data.neo4j.web"})
@EnableNeo4jRepositories(value={"org.springframework.data.neo4j.web.repo"})
@EnableTransactionManagement
public class WebPersistenceContext
extends Neo4jConfiguration {
    @Bean
    public Neo4jServer neo4jServer() {
        return new InProcessServer();
    }

    @Bean
    public SessionFactory getSessionFactory() {
        return new SessionFactory(new String[]{"org.springframework.data.neo4j.web.domain"});
    }

    @Bean
    @Scope(value="session", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public Session getSession() throws Exception {
        return super.getSession();
    }
}

