/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.neo4j.ogm.session.Session;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.annotation.QueryResult;
import org.springframework.data.neo4j.repository.query.GraphRepositoryQuery;
import org.springframework.data.neo4j.repository.query.QueryResultGraphRepositoryQuery;
import org.springframework.data.neo4j.repository.query.derived.DerivedGraphRepositoryQuery;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;

public class GraphQueryMethod
extends QueryMethod {
    private final Session session;
    private final Method method;
    private final Query queryAnnotation;

    public GraphQueryMethod(Method method, RepositoryMetadata metadata, Session session) {
        super(method, metadata);
        this.method = method;
        this.session = session;
        this.queryAnnotation = method.getAnnotation(Query.class);
    }

    public String getQuery() {
        return this.queryAnnotation.value();
    }

    public Method getMethod() {
        return this.method;
    }

    public String getNamedQueryName() {
        throw new UnsupportedOperationException("OGM does not currently support named queries.");
    }

    public Class<?> resolveConcreteReturnType() {
        Class<?> type = this.method.getReturnType();
        Type genericType = this.method.getGenericReturnType();
        if (Iterable.class.isAssignableFrom(type)) {
            if (genericType instanceof ParameterizedType) {
                ParameterizedType returnType = (ParameterizedType)genericType;
                Type componentType = returnType.getActualTypeArguments()[0];
                return componentType instanceof ParameterizedType ? (Class)((ParameterizedType)componentType).getRawType() : (Class)componentType;
            }
            return Object.class;
        }
        return type;
    }

    public RepositoryQuery createQuery() {
        if (this.method.getAnnotation(Query.class) != null) {
            if (this.resolveConcreteReturnType().isAnnotationPresent(QueryResult.class)) {
                return new QueryResultGraphRepositoryQuery(this, this.session);
            }
            return new GraphRepositoryQuery(this, this.session);
        }
        return new DerivedGraphRepositoryQuery(this, this.session);
    }
}

