/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.neo4j.ogm.cypher.query.RowModelQuery;
import org.neo4j.ogm.entityaccess.EntityFactory;
import org.neo4j.ogm.mapper.SingleUseEntityMapper;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.session.GraphCallback;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.request.RequestHandler;
import org.neo4j.ogm.session.response.Neo4jResponse;
import org.neo4j.ogm.session.result.Result;
import org.neo4j.ogm.session.result.RowModel;
import org.neo4j.ogm.session.transaction.Transaction;
import org.springframework.data.neo4j.repository.query.GraphQueryMethod;
import org.springframework.data.neo4j.repository.query.GraphRepositoryQuery;
import org.springframework.data.neo4j.repository.query.QueryResultProxy;

public class QueryResultGraphRepositoryQuery
extends GraphRepositoryQuery {
    public QueryResultGraphRepositoryQuery(GraphQueryMethod graphQueryMethod, Session session) {
        super(graphQueryMethod, session);
    }

    @Override
    protected Object execute(Class<?> returnType, Class<?> concreteReturnType, String cypherQuery, Map<String, Object> queryParams) {
        Collection<Object> resultObjects;
        Collection<Object> collection = resultObjects = concreteReturnType.isInterface() ? this.mapToProxy(concreteReturnType, cypherQuery, queryParams) : this.mapToConcreteType(concreteReturnType, cypherQuery, queryParams);
        if (Iterable.class.isAssignableFrom(returnType)) {
            return resultObjects;
        }
        return resultObjects.isEmpty() ? null : resultObjects.iterator().next();
    }

    private Collection<Object> mapToConcreteType(final Class<?> targetType, String cypherQuery, Map<String, Object> queryParams) {
        final RowModelQuery qry = new RowModelQuery(cypherQuery, queryParams);
        return (Collection)this.session.doInTransaction((GraphCallback)new GraphCallback<Collection<Object>>(){

            public Collection<Object> apply(RequestHandler requestHandler, Transaction transaction, MetaData metaData) {
                try (Neo4jResponse response = requestHandler.execute(qry, transaction.url());){
                    ArrayList<Object> toReturn = new ArrayList<Object>();
                    SingleUseEntityMapper entityMapper = new SingleUseEntityMapper(metaData, new EntityFactory(metaData));
                    RowModel rowModel = (RowModel)response.next();
                    while (rowModel != null) {
                        toReturn.add(entityMapper.map(targetType, response.columns(), rowModel));
                        rowModel = (RowModel)response.next();
                    }
                    ArrayList<Object> arrayList = toReturn;
                    return arrayList;
                }
            }
        });
    }

    private Collection<Object> mapToProxy(Class<?> targetType, String cypherQuery, Map<String, Object> queryParams) {
        Result queryResults = this.session.query(cypherQuery, queryParams);
        ArrayList<Object> resultObjects = new ArrayList<Object>();
        Class[] interfaces = new Class[]{targetType};
        for (Map map : queryResults) {
            resultObjects.add(Proxy.newProxyInstance(targetType.getClassLoader(), interfaces, (InvocationHandler)new QueryResultProxy(map)));
        }
        return resultObjects;
    }
}

