/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.integration.conversion;

import java.lang.annotation.ElementType;
import java.math.BigInteger;
import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.neo4j.integration.conversion.ConversionServicePersistenceContext;
import org.springframework.data.neo4j.integration.conversion.JavaElementRepository;
import org.springframework.data.neo4j.integration.conversion.PensionRepository;
import org.springframework.data.neo4j.integration.conversion.SiteMemberRepository;
import org.springframework.data.neo4j.integration.conversion.SpringBigIntegerToBooleanConverter;
import org.springframework.data.neo4j.integration.conversion.SpringBooleanToBigIntegerConverter;
import org.springframework.data.neo4j.integration.conversion.SpringByteArrayToIntegerConverter;
import org.springframework.data.neo4j.integration.conversion.SpringIntegerToByteArrayConverter;
import org.springframework.data.neo4j.integration.conversion.SpringIntegerToMonetaryAmountConverter;
import org.springframework.data.neo4j.integration.conversion.SpringMonetaryAmountToIntegerConverter;
import org.springframework.data.neo4j.integration.conversion.SpringMonetaryAmountToNumberConverterFactory;
import org.springframework.data.neo4j.integration.conversion.domain.JavaElement;
import org.springframework.data.neo4j.integration.conversion.domain.MonetaryAmount;
import org.springframework.data.neo4j.integration.conversion.domain.PensionPlan;
import org.springframework.data.neo4j.integration.conversion.domain.SiteMember;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes={ConversionServicePersistenceContext.class})
public class ConversionServiceTest
extends MultiDriverTestClass {
    private GraphDatabaseService graphDatabaseService = ConversionServiceTest.getGraphDatabaseService();
    @Autowired
    private PensionRepository pensionRepository;
    @Autowired
    private JavaElementRepository javaElementRepository;
    @Autowired
    private SiteMemberRepository siteMemberRepository;
    @Autowired
    private GenericConversionService conversionService;
    @Autowired
    Session session;

    @After
    public void cleanUpDatabase() {
        this.session.purgeDatabase();
    }

    @Test
    public void shouldBeAbleToConvertBetweenBytesAndBase64EncodedDataViaSpringConversionService() {
        String base64Representation = "YmNkZWY=";
        byte[] binaryData = new byte[]{98, 99, 100, 101, 102};
        Assert.assertTrue((boolean)this.conversionService.canConvert(byte[].class, String.class));
        Assert.assertEquals((Object)base64Representation, (Object)this.conversionService.convert((Object)binaryData, String.class));
        Assert.assertTrue((boolean)this.conversionService.canConvert(String.class, byte[].class));
        Assert.assertTrue((boolean)Arrays.equals(binaryData, (byte[])this.conversionService.convert((Object)base64Representation, byte[].class)));
    }

    @Test
    public void shouldConvertBase64StringOutOfGraphDatabaseBackIntoByteArray() {
        Result rs = this.graphDatabaseService.execute("CREATE (u:SiteMember {profilePictureData:'MTIzNDU2Nzg5'}) RETURN id(u) AS userId");
        Long userId = (Long)rs.columnAs("userId").next();
        byte[] expectedData = "123456789".getBytes();
        SiteMember siteMember = (SiteMember)this.siteMemberRepository.findOne(userId);
        Assert.assertTrue((String)"The data wasn't converted correctly", (boolean)Arrays.equals(expectedData, siteMember.getProfilePictureData()));
    }

    @Test
    public void shouldConvertFieldsUsingSpringConvertersAddedDirectlyToConversionService() {
        this.conversionService.addConverter((Converter)new SpringMonetaryAmountToIntegerConverter());
        this.conversionService.addConverter((Converter)new SpringIntegerToMonetaryAmountConverter());
        PensionPlan pensionToSave = new PensionPlan(new MonetaryAmount(16472, 81), "Tightfist Asset Management Ltd");
        this.pensionRepository.save(pensionToSave);
        ResourceIterator resourceIterator = this.graphDatabaseService.execute("MATCH (p:PensionPlan) RETURN p.fundValue AS fv").columnAs("fv");
        Assert.assertTrue((String)"Nothing was saved", (boolean)resourceIterator.hasNext());
        Assert.assertEquals((String)"The amount wasn't converted and persisted correctly", (long)1647281L, (long)((Number)resourceIterator.next()).intValue());
        PensionPlan reloadedPension = (PensionPlan)this.pensionRepository.findOne(pensionToSave.getPensionPlanId());
        Assert.assertEquals((String)"The amount was converted incorrectly", (Object)pensionToSave.getFundValue(), (Object)reloadedPension.getFundValue());
    }

    @Test
    public void shouldConvertFieldsUsingAnAvailableSupertypeConverterIfExactTypesDoNotMatch() {
        this.conversionService.addConverterFactory((ConverterFactory)new SpringMonetaryAmountToNumberConverterFactory());
        PensionPlan pension = new PensionPlan(new MonetaryAmount(20000, 0), "Ashes Assets LLP");
        this.pensionRepository.save(pension);
        ResourceIterator resourceIterator = this.graphDatabaseService.execute("MATCH (p:PensionPlan) RETURN p.fundValue AS fv").columnAs("fv");
        Assert.assertTrue((String)"Nothing was saved", (boolean)resourceIterator.hasNext());
        Assert.assertEquals((String)"The amount wasn't converted and persisted correctly", (long)2000000L, (long)((Integer)resourceIterator.next()).intValue());
    }

    @Test
    public void shouldOperateWithDefaultSpringConvertersToConvertObjectTypesNotInMetaData() {
        DefaultConversionService.addDefaultConverters((ConverterRegistry)this.conversionService);
        JavaElement method = new JavaElement();
        method.setName("toString");
        method.setElementType(ElementType.METHOD);
        this.javaElementRepository.save(method);
        ResourceIterator resourceIterator = this.graphDatabaseService.execute("MATCH (e:JavaElement) RETURN e.elementType AS type").columnAs("type");
        Assert.assertTrue((String)"Nothing was saved", (boolean)resourceIterator.hasNext());
        Assert.assertEquals((String)"The element type wasn't converted and persisted correctly", (Object)"METHOD", (Object)resourceIterator.next());
        JavaElement loadedObject = (JavaElement)this.javaElementRepository.findAll().iterator().next();
        Assert.assertEquals((String)"The element type wasn't loaded and converted correctly", (Object)((Object)ElementType.METHOD), (Object)((Object)loadedObject.getElementType()));
    }

    @Test(expected=ConverterNotFoundException.class)
    public void shouldThrowExceptionIfSuitableConverterIsNotFound() {
        this.conversionService.addConverterFactory((ConverterFactory)new SpringMonetaryAmountToNumberConverterFactory());
        PensionPlan pension = new PensionPlan(new MonetaryAmount(20000, 0), "Ashes Assets LLP");
        pension.setJavaElement(new JavaElement());
        this.pensionRepository.save(pension);
    }

    @Test
    public void shouldUseSpecifiedAttributeConverterInsteadOfSprings() {
        this.conversionService.addConverter((Converter)new SpringIntegerToByteArrayConverter());
        this.conversionService.addConverter((Converter)new SpringByteArrayToIntegerConverter());
        String base64Representation = "YmNkZWY=";
        byte[] binaryData = new byte[]{98, 99, 100, 101, 102};
        Assert.assertTrue((boolean)this.conversionService.canConvert(byte[].class, String.class));
        Assert.assertEquals((Object)base64Representation, (Object)this.conversionService.convert((Object)binaryData, String.class));
        Assert.assertTrue((boolean)this.conversionService.canConvert(String.class, byte[].class));
        Assert.assertTrue((boolean)Arrays.equals(binaryData, (byte[])this.conversionService.convert((Object)base64Representation, byte[].class)));
        SiteMember siteMember = new SiteMember();
        siteMember.setProfilePictureData(binaryData);
        this.siteMemberRepository.save(siteMember);
        this.session.clear();
        siteMember = (SiteMember)this.session.loadAll(SiteMember.class).iterator().next();
        Assert.assertArrayEquals((byte[])binaryData, (byte[])siteMember.getProfilePictureData());
    }

    @Test
    public void shouldUseDefaultAttributeConverterInsteadOfSprings() {
        this.conversionService.addConverter((Converter)new SpringBigIntegerToBooleanConverter());
        this.conversionService.addConverter((Converter)new SpringBooleanToBigIntegerConverter());
        byte[] binaryData = new byte[]{98, 99, 100, 101, 102};
        SiteMember siteMember = new SiteMember();
        siteMember.setProfilePictureData(binaryData);
        siteMember.setYears(BigInteger.valueOf(50L));
        this.siteMemberRepository.save(siteMember);
        this.session.clear();
        siteMember = (SiteMember)this.session.loadAll(SiteMember.class).iterator().next();
        Assert.assertArrayEquals((byte[])binaryData, (byte[])siteMember.getProfilePictureData());
        Assert.assertEquals((long)50L, (long)siteMember.getYears().intValue());
    }
}

