/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.queries;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.ogm.exception.MappingException;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.examples.movies.context.MoviesContext;
import org.springframework.data.neo4j.examples.movies.domain.Rating;
import org.springframework.data.neo4j.examples.movies.domain.TempMovie;
import org.springframework.data.neo4j.examples.movies.domain.User;
import org.springframework.data.neo4j.examples.movies.domain.queryresult.EntityWrappingQueryResult;
import org.springframework.data.neo4j.examples.movies.domain.queryresult.Gender;
import org.springframework.data.neo4j.examples.movies.domain.queryresult.RichUserQueryResult;
import org.springframework.data.neo4j.examples.movies.domain.queryresult.UserQueryResult;
import org.springframework.data.neo4j.examples.movies.domain.queryresult.UserQueryResultInterface;
import org.springframework.data.neo4j.examples.movies.repo.CinemaRepository;
import org.springframework.data.neo4j.examples.movies.repo.UnmanagedUserPojo;
import org.springframework.data.neo4j.examples.movies.repo.UserRepository;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(classes={MoviesContext.class})
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public class QueryIntegrationTest
extends MultiDriverTestClass {
    private static GraphDatabaseService graphDatabaseService = QueryIntegrationTest.getGraphDatabaseService();
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private CinemaRepository cinemaRepository;

    @Before
    public void init() {
        this.clearDatabase();
    }

    @After
    public void clearDatabase() {
        graphDatabaseService.execute("MATCH (n) OPTIONAL MATCH (n)-[r]-() DELETE r, n");
    }

    private void executeUpdate(String cypher) {
        graphDatabaseService.execute(cypher);
    }

    @Test
    public void shouldFindArbitraryGraph() {
        this.executeUpdate("CREATE (dh:Movie {name:'Die Hard'}), (fe:Movie {name: 'The Fifth Element'}), (bw:User {name: 'Bruce Willis'}), (ar:User {name: 'Alan Rickman'}), (mj:User {name: 'Milla Jovovich'}), (mj)-[:ACTED_IN]->(fe), (ar)-[:ACTED_IN]->(dh), (bw)-[:ACTED_IN]->(dh), (bw)-[:ACTED_IN]->(fe)");
        List<Map<String, Object>> graph = this.userRepository.getGraph();
        Assert.assertNotNull(graph);
        int i = 0;
        for (Map<String, Object> properties : graph) {
            ++i;
            Assert.assertNotNull(properties);
        }
        Assert.assertEquals((long)2L, (long)i);
    }

    @Test
    public void shouldFindScalarValues() {
        this.executeUpdate("CREATE (m:User {name:'Michal'})<-[:FRIEND_OF]-(a:User {name:'Adam'})");
        List<Integer> ids = this.userRepository.getUserIds();
        Assert.assertEquals((long)2L, (long)ids.size());
        List<Long> nodeIds = this.userRepository.getUserNodeIds();
        Assert.assertEquals((long)2L, (long)nodeIds.size());
    }

    @Test
    public void shouldFindUserByName() {
        this.executeUpdate("CREATE (m:User {name:'Michal'})<-[:FRIEND_OF]-(a:User {name:'Adam'})");
        User user = this.userRepository.findUserByName("Michal");
        Assert.assertEquals((Object)"Michal", (Object)user.getName());
    }

    @Test
    public void shouldFindTotalUsers() {
        this.executeUpdate("CREATE (m:User {name:'Michal'})<-[:FRIEND_OF]-(a:User {name:'Adam'})");
        int users = this.userRepository.findTotalUsers();
        Assert.assertEquals((long)users, (long)2L);
    }

    @Test
    public void shouldFindUsers() {
        this.executeUpdate("CREATE (m:User {name:'Michal'})<-[:FRIEND_OF]-(a:User {name:'Adam'})");
        Collection<User> users = this.userRepository.getAllUsers();
        Assert.assertEquals((long)users.size(), (long)2L);
    }

    @Test
    public void shouldFindUserByNameWithNamedParam() {
        this.executeUpdate("CREATE (m:User {name:'Michal'})<-[:FRIEND_OF]-(a:User {name:'Adam'})");
        User user = this.userRepository.findUserByNameWithNamedParam("Michal");
        Assert.assertEquals((Object)"Michal", (Object)user.getName());
    }

    @Test
    public void shouldFindUsersAsProperties() {
        this.executeUpdate("CREATE (m:User {name:'Michal'})<-[:FRIEND_OF]-(a:User {name:'Adam'})");
        Iterable<Map<String, Object>> users = this.userRepository.getUsersAsProperties();
        Assert.assertNotNull(users);
        int i = 0;
        for (Map<String, Object> properties : users) {
            ++i;
            Assert.assertNotNull(properties);
        }
        Assert.assertEquals((long)2L, (long)i);
    }

    @Test
    public void shouldFindUsersAndMapThemToConcreteQueryResultObjectCollection() {
        this.executeUpdate("CREATE (g:User {name:'Gary', age:32}), (s:User {name:'Sheila', age:29}), (v:User {name:'Vince', age:66})");
        Assert.assertEquals((String)"There should be some users in the database", (long)3L, (long)this.userRepository.findTotalUsers());
        List<UserQueryResult> expected = Arrays.asList(new UserQueryResult("Sheila", 29), new UserQueryResult("Gary", 32), new UserQueryResult("Vince", 66));
        Iterable<UserQueryResult> queryResult = this.userRepository.retrieveAllUsersAndTheirAges();
        Assert.assertNotNull((String)"The query result shouldn't be null", queryResult);
        Assert.assertEquals(expected, queryResult);
        for (UserQueryResult userQueryResult : queryResult) {
            Assert.assertNotNull((Object)userQueryResult.getUserId());
        }
    }

    @Test(expected=MappingException.class)
    public void shouldThrowMappingExceptionIfQueryResultTypeIsNotManagedInMappingMetadata() {
        this.executeUpdate("CREATE (:User {name:'Colin'}), (:User {name:'Jeff'})");
        UnmanagedUserPojo queryResult = this.userRepository.findIndividualUserAsDifferentObject("Jeff");
        Assert.assertNotNull((String)"The query result shouldn't be null", (Object)queryResult);
        Assert.assertEquals((Object)"Jeff", (Object)queryResult.getName());
    }

    @Test
    public void shouldFindUsersAndMapThemToProxiedQueryResultInterface() {
        this.executeUpdate("CREATE (:User {name:'Morne', age:30}), (:User {name:'Abraham', age:31}), (:User {name:'Virat', age:27})");
        UserQueryResultInterface result = this.userRepository.findIndividualUserAsProxiedObject("Abraham");
        Assert.assertNotNull((String)"The query result shouldn't be null", (Object)result);
        Assert.assertEquals((String)"The wrong user was returned", (Object)"Abraham", (Object)result.getNameOfUser());
        Assert.assertEquals((String)"The wrong user was returned", (long)31L, (long)result.getAgeOfUser());
    }

    @Test
    public void shouldRetrieveUsersByGenderAndConvertToCorrectTypes() {
        this.executeUpdate("CREATE (:User {name:'David Warner', gender:'MALE'}), (:User {name:'Shikhar Dhawan', gender:'MALE'}), (:User {name:'Sarah Taylor', gender:'FEMALE', account: '3456789', deposits:['12345.6','45678.9']})");
        Iterable<RichUserQueryResult> usersByGender = this.userRepository.findUsersByGender(Gender.FEMALE);
        Assert.assertNotNull((String)"The resultant users list shouldn't be null", usersByGender);
        Iterator<RichUserQueryResult> userIterator = usersByGender.iterator();
        Assert.assertTrue((boolean)userIterator.hasNext());
        RichUserQueryResult userQueryResult = userIterator.next();
        Assert.assertEquals((Object)((Object)Gender.FEMALE), (Object)((Object)userQueryResult.getUserGender()));
        Assert.assertEquals((Object)"Sarah Taylor", (Object)userQueryResult.getUserName());
        Assert.assertEquals((Object)BigInteger.valueOf(3456789L), (Object)userQueryResult.getUserAccount());
        Assert.assertArrayEquals((Object[])new BigDecimal[]{BigDecimal.valueOf(12345.6), BigDecimal.valueOf(45678.9)}, (Object[])userQueryResult.getUserDeposits());
        Assert.assertFalse((boolean)userIterator.hasNext());
    }

    @Test
    public void shouldSubstituteUserId() {
        this.executeUpdate("CREATE (m:User {name:'Michal'})<-[:FRIEND_OF]-(a:User {name:'Adam'})");
        User michal = this.userRepository.findUserByName("Michal");
        Assert.assertNotNull((Object)michal);
        User user = this.userRepository.loadUserById(michal);
        Assert.assertEquals((Object)"Michal", (Object)user.getName());
    }

    @Test
    public void shouldSubstituteNamedParamUserId() {
        this.executeUpdate("CREATE (m:User {name:'Michal'})<-[:FRIEND_OF]-(a:User {name:'Adam'})");
        User michal = this.userRepository.findUserByName("Michal");
        Assert.assertNotNull((Object)michal);
        User user = this.userRepository.loadUserByNamedId(michal);
        Assert.assertEquals((Object)"Michal", (Object)user.getName());
    }

    @Test
    public void shouldFindIterableUsers() {
        this.executeUpdate("CREATE (m:User {name:'Michal'})<-[:FRIEND_OF]-(a:User {name:'Adam'})");
        Iterable<User> users = this.userRepository.getAllUsersIterable();
        int count = 0;
        for (User user : users) {
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void shouldAllowNullParameters() {
        this.executeUpdate("CREATE (m:User {name:'Michal'})<-[:FRIEND_OF]-(a:User {name:'Adam'})");
        this.userRepository.setNamesNull(null);
        Iterable users = this.userRepository.findAll();
        for (User u : users) {
            Assert.assertNull((Object)u.getName());
        }
    }

    @Test
    public void shouldMapNullsToQueryResults() {
        this.executeUpdate("CREATE (g:User), (s:User)");
        Assert.assertEquals((String)"There should be some users in the database", (long)2L, (long)this.userRepository.findTotalUsers());
        List<UserQueryResult> expected = Arrays.asList(new UserQueryResult(null, 0), new UserQueryResult(null, 0));
        Iterable<UserQueryResult> queryResult = this.userRepository.retrieveAllUsersAndTheirAges();
        Assert.assertNotNull((String)"The query result shouldn't be null", queryResult);
        Assert.assertEquals(expected, queryResult);
        for (UserQueryResult userQueryResult : queryResult) {
            Assert.assertNotNull((Object)userQueryResult.getUserId());
        }
    }

    @Test
    public void shouldMapNodeEntitiesIntoQueryResultObjects() {
        this.executeUpdate("CREATE (:User {name:'Abraham'}), (:User {name:'Barry'}), (:User {name:'Colin'})");
        EntityWrappingQueryResult wrappedUser = this.userRepository.findWrappedUserByName("Barry");
        Assert.assertNotNull((String)"The loaded wrapper object shouldn't be null", (Object)wrappedUser);
        Assert.assertNotNull((String)"The enclosed user shouldn't be null", (Object)wrappedUser.getUser());
        Assert.assertEquals((Object)"Barry", (Object)wrappedUser.getUser().getName());
    }

    @Test
    public void shouldMapNodeCollectionsIntoQueryResultObjects() {
        this.executeUpdate("CREATE (d:User {name:'Daniela'}),  (e:User {name:'Ethan'}), (f:User {name:'Finn'}), (d)-[:FRIEND_OF]->(e), (d)-[:FRIEND_OF]->(f)");
        EntityWrappingQueryResult result = this.userRepository.findWrappedUserAndFriendsDepth1("Daniela");
        Assert.assertNotNull((String)"The result shouldn't be null", (Object)result);
        Assert.assertNotNull((String)"The enclosed user shouldn't be null", (Object)result.getUser());
        Assert.assertEquals((Object)"Daniela", (Object)result.getUser().getName());
        Assert.assertEquals((long)2L, (long)result.getFriends().size());
        ArrayList<String> friends = new ArrayList<String>();
        for (User u : result.getFriends()) {
            friends.add(u.getName());
        }
        Assert.assertTrue((boolean)friends.contains("Ethan"));
        Assert.assertTrue((boolean)friends.contains("Finn"));
        Assert.assertEquals((long)2L, (long)result.getUser().getFriends().size());
    }

    @Test
    public void shouldMapRECollectionsIntoQueryResultObjects() {
        this.executeUpdate("CREATE (g:User {name:'Gary'}), (sw:Movie {name: 'Star Wars: The Force Awakens'}), (hob:Movie {name:'The Hobbit: An Unexpected Journey'}), (g)-[:RATED {stars : 5}]->(sw), (g)-[:RATED {stars: 4}]->(hob) ");
        EntityWrappingQueryResult result = this.userRepository.findWrappedUserAndRatingsByName("Gary");
        Assert.assertNotNull((String)"The loaded wrapper object shouldn't be null", (Object)result);
        Assert.assertNotNull((String)"The enclosed user shouldn't be null", (Object)result.getUser());
        Assert.assertEquals((Object)"Gary", (Object)result.getUser().getName());
        Assert.assertEquals((long)2L, (long)result.getRatings().size());
        for (Rating rating : result.getRatings()) {
            if (rating.getStars() == 4) {
                Assert.assertEquals((Object)"The Hobbit: An Unexpected Journey", (Object)rating.getMovie().getName());
                continue;
            }
            Assert.assertEquals((Object)"Star Wars: The Force Awakens", (Object)rating.getMovie().getName());
        }
        Assert.assertEquals((float)4.5f, (float)result.getAvgRating(), (float)0.0f);
        Assert.assertEquals((long)2L, (long)result.getMovies().length);
        ArrayList<String> titles = new ArrayList<String>();
        for (TempMovie movie : result.getMovies()) {
            titles.add(movie.getName());
        }
        Assert.assertTrue((boolean)titles.contains("The Hobbit: An Unexpected Journey"));
        Assert.assertTrue((boolean)titles.contains("Star Wars: The Force Awakens"));
    }

    @Test
    public void shouldMapRelationshipCollectionsWithDepth0IntoQueryResultObjects() {
        this.executeUpdate("CREATE (i:User {name:'Ingrid'}),  (j:User {name:'Jake'}), (k:User {name:'Kate'}), (i)-[:FRIEND_OF]->(j), (i)-[:FRIEND_OF]->(k)");
        EntityWrappingQueryResult result = this.userRepository.findWrappedUserAndFriendsDepth0("Ingrid");
        Assert.assertNotNull((String)"The result shouldn't be null", (Object)result);
        Assert.assertNotNull((String)"The enclosed user shouldn't be null", (Object)result.getUser());
        Assert.assertEquals((Object)"Ingrid", (Object)result.getUser().getName());
        Assert.assertEquals((long)2L, (long)result.getFriends().size());
        ArrayList<String> friends = new ArrayList<String>();
        for (User u : result.getFriends()) {
            friends.add(u.getName());
        }
        Assert.assertTrue((boolean)friends.contains("Kate"));
        Assert.assertTrue((boolean)friends.contains("Jake"));
        Assert.assertEquals((long)0L, (long)result.getUser().getFriends().size());
    }

    @Test
    public void shouldReturnMultipleQueryResultObjects() {
        this.executeUpdate("CREATE (g:User {name:'Gary'}), (h:User {name:'Harry'}), (sw:Movie {name: 'Star Wars: The Force Awakens'}), (hob:Movie {name:'The Hobbit: An Unexpected Journey'}), (g)-[:RATED {stars : 5}]->(sw), (g)-[:RATED {stars: 4}]->(hob), (h)-[:RATED {stars: 3}]->(hob) ");
        List<EntityWrappingQueryResult> results = this.userRepository.findAllUserRatings();
        Assert.assertEquals((long)2L, (long)results.size());
        EntityWrappingQueryResult result = results.get(0);
        Assert.assertNotNull((String)"The loaded wrapper object shouldn't be null", (Object)result);
        Assert.assertNotNull((String)"The enclosed user shouldn't be null", (Object)result.getUser());
        Assert.assertEquals((Object)"Harry", (Object)result.getUser().getName());
        Assert.assertEquals((long)1L, (long)result.getRatings().size());
        Rating rating = result.getRatings().get(0);
        Assert.assertEquals((Object)"The Hobbit: An Unexpected Journey", (Object)rating.getMovie().getName());
        Assert.assertEquals((long)3L, (long)rating.getStars());
        Assert.assertEquals((float)3.0f, (float)result.getAvgRating(), (float)0.0f);
        Assert.assertEquals((long)1L, (long)result.getMovies().length);
        Assert.assertEquals((Object)"The Hobbit: An Unexpected Journey", (Object)result.getMovies()[0].getName());
        result = results.get(1);
        Assert.assertNotNull((String)"The loaded wrapper object shouldn't be null", (Object)result);
        Assert.assertNotNull((String)"The enclosed user shouldn't be null", (Object)result.getUser());
        Assert.assertEquals((Object)"Gary", (Object)result.getUser().getName());
        for (Rating r : result.getRatings()) {
            if (r.getStars() == 4) {
                Assert.assertEquals((Object)"The Hobbit: An Unexpected Journey", (Object)r.getMovie().getName());
                continue;
            }
            Assert.assertEquals((Object)"Star Wars: The Force Awakens", (Object)r.getMovie().getName());
        }
        Assert.assertEquals((float)4.5f, (float)result.getAvgRating(), (float)0.0f);
        Assert.assertEquals((long)2L, (long)result.getMovies().length);
        ArrayList<String> titles = new ArrayList<String>();
        for (TempMovie movie : result.getMovies()) {
            titles.add(movie.getName());
        }
        Assert.assertTrue((boolean)titles.contains("The Hobbit: An Unexpected Journey"));
        Assert.assertTrue((boolean)titles.contains("Star Wars: The Force Awakens"));
    }

    @Test
    public void shouldMapEntitiesToProxiedQueryResultInterface() {
        this.executeUpdate("CREATE (:User {name:'Morne', age:30}), (:User {name:'Abraham', age:31}), (:User {name:'Virat', age:27})");
        UserQueryResultInterface result = this.userRepository.findWrappedUserAsProxiedObject("Abraham");
        Assert.assertNotNull((String)"The query result shouldn't be null", (Object)result);
        Assert.assertNotNull((String)"The mapped user shouldn't be null", (Object)result.getUser());
        Assert.assertEquals((String)"The wrong user was returned", (Object)"Abraham", (Object)result.getUser().getName());
        Assert.assertEquals((String)"The wrong user was returned", (long)31L, (long)result.getAgeOfUser());
    }
}

